/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geronimo.gbean.GAttributeInfo;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.kernel.GBeanNotFoundException;
import org.apache.geronimo.kernel.Kernel;
import org.apache.geronimo.kernel.NoSuchAttributeException;
import org.apache.geronimo.system.main.StartupMonitor;

public class ProgressBarStartupMonitor
implements StartupMonitor {
    private static final char STATUS_NOT_READY = ' ';
    private static final char STATUS_LOADING = '-';
    private static final char STATUS_LOADED = '>';
    private static final char STATUS_STARTED = '*';
    private static final char STATUS_FAILED = 'x';
    private static final int MAX_WIDTH = 70;
    private PrintStream out;
    private String currentOperation;
    private URI[] configurations;
    private char[] configStatus;
    private long started;
    private int percent = 0;
    private Kernel kernel;
    private int operationLimit = 50;
    private boolean finished = false;
    private List exceptions = new ArrayList();
    private UpdateThread thread;

    public void systemStarting(long startTime) {
        this.out = System.out;
        this.started = startTime;
    }

    public void systemStarted(Kernel kernel) {
        this.out.println("Starting Geronimo Application Server");
        this.kernel = kernel;
        this.currentOperation = "Loading";
    }

    public synchronized void foundConfigurations(URI[] configurations) {
        this.configurations = configurations;
        this.configStatus = new char[configurations.length];
        for (int i = 0; i < this.configStatus.length; ++i) {
            this.configStatus[i] = 32;
        }
        this.operationLimit = 65 - configurations.length - 4 - 5;
        this.repaint();
        this.thread = new UpdateThread();
        this.thread.start();
    }

    public void calculatePercent() {
        if (this.finished) {
            this.percent = 100;
            return;
        }
        int percent = 0;
        if (this.kernel != null) {
            percent += 5;
        }
        int total = this.configStatus.length * 2;
        int progress = 0;
        block4: for (int i = 0; i < this.configStatus.length; ++i) {
            char c = this.configStatus[i];
            switch (c) {
                case '>': {
                    ++progress;
                    continue block4;
                }
                case '*': 
                case 'x': {
                    progress += 2;
                }
            }
        }
        this.percent = percent += Math.round(90.0f * (float)progress / (float)total);
    }

    public synchronized void configurationLoading(URI configuration) {
        this.currentOperation = " Loading " + configuration;
        for (int i = 0; i < this.configurations.length; ++i) {
            if (!this.configurations[i].equals(configuration)) continue;
            this.configStatus[i] = 45;
        }
        this.repaint();
    }

    public synchronized void configurationLoaded(URI configuration) {
        for (int i = 0; i < this.configurations.length; ++i) {
            if (!this.configurations[i].equals(configuration)) continue;
            this.configStatus[i] = 62;
        }
        this.calculatePercent();
        this.repaint();
    }

    public synchronized void configurationStarting(URI configuration) {
        this.currentOperation = "Starting " + configuration;
    }

    public synchronized void configurationStarted(URI configuration) {
        for (int i = 0; i < this.configurations.length; ++i) {
            if (!this.configurations[i].equals(configuration)) continue;
            this.configStatus[i] = 42;
        }
        this.calculatePercent();
        this.repaint();
    }

    public synchronized void startupFinished() {
        this.finished = true;
        this.currentOperation = "Startup complete";
        this.calculatePercent();
        this.thread.done = true;
        this.thread.interrupt();
    }

    private void wrapUp() {
        this.repaint();
        this.out.println();
        try {
            Set gbeans = this.kernel.listGBeans(new ObjectName("*:*"));
            HashMap beanInfos = new HashMap();
            ArrayList<AddressHolder> ports = new ArrayList<AddressHolder>();
            ObjectName serverInfo = null;
            boolean firstApp = true;
            Iterator it = gbeans.iterator();
            while (it.hasNext()) {
                ArrayList<GAttributeInfo> list;
                GBeanInfo info;
                ObjectName name = (ObjectName)it.next();
                if (ProgressBarStartupMonitor.isApplicationModule(name)) {
                    if (firstApp) {
                        firstApp = false;
                        this.out.println("  Started Application Modules:");
                    }
                    this.out.println("    " + ProgressBarStartupMonitor.decodeModule(name.getKeyProperty("j2eeType")) + ": " + name.getKeyProperty("name"));
                }
                if ((info = this.kernel.getGBeanInfo(name)).getClassName().equals("org.apache.geronimo.system.serverinfo.ServerInfo")) {
                    serverInfo = name;
                }
                if ((list = (ArrayList<GAttributeInfo>)beanInfos.get(info)) == null) {
                    list = new ArrayList<GAttributeInfo>(3);
                    beanInfos.put(info, list);
                    Set atts = info.getAttributes();
                    Iterator it2 = atts.iterator();
                    while (it2.hasNext()) {
                        GAttributeInfo att = (GAttributeInfo)it2.next();
                        if (!att.getType().equals("java.net.InetSocketAddress")) continue;
                        list.add(att);
                    }
                }
                for (int i = 0; i < list.size(); ++i) {
                    GAttributeInfo att = (GAttributeInfo)list.get(i);
                    try {
                        InetSocketAddress addr = (InetSocketAddress)this.kernel.getAttribute(name, att.getName());
                        if (addr == null) continue;
                        String attName = info.getName();
                        if (list.size() > 1) {
                            attName = attName + " " + ProgressBarStartupMonitor.decamelize(att.getName());
                        } else if (info.getAttribute("name") != null) {
                            attName = attName + " " + this.kernel.getAttribute(name, "name");
                        }
                        ports.add(new AddressHolder(attName, addr));
                        continue;
                    }
                    catch (IllegalStateException e) {
                        // empty catch block
                    }
                }
            }
            Collections.sort(ports);
            if (ports.size() > 0) {
                AddressHolder holder;
                int i;
                System.out.println("  Listening on Ports:");
                int max = 0;
                for (i = 0; i < ports.size(); ++i) {
                    holder = (AddressHolder)ports.get(i);
                    max = Math.max(max, holder.getAddress().getAddress().getHostAddress().length());
                }
                for (i = 0; i < ports.size(); ++i) {
                    holder = (AddressHolder)ports.get(i);
                    StringBuffer buf = new StringBuffer();
                    buf.append("   ");
                    if (holder.getAddress().getPort() < 10) {
                        buf.append(' ');
                    }
                    if (holder.getAddress().getPort() < 100) {
                        buf.append(' ');
                    }
                    if (holder.getAddress().getPort() < 1000) {
                        buf.append(' ');
                    }
                    if (holder.getAddress().getPort() < 10000) {
                        buf.append(' ');
                    }
                    buf.append(holder.getAddress().getPort()).append(' ');
                    buf.append(holder.getAddress().getAddress().getHostAddress());
                    for (int j = holder.getAddress().getAddress().getHostAddress().length(); j <= max; ++j) {
                        buf.append(' ');
                    }
                    buf.append(holder.getName());
                    this.out.println(buf.toString());
                }
            }
            StringBuffer msg = new StringBuffer();
            msg.append("Geronimo Application Server started");
            if (serverInfo != null) {
                msg.append(" (version ").append(this.kernel.getAttribute(serverInfo, "version") + ")");
            }
            this.out.println(msg.toString());
            this.out.flush();
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (GBeanNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchAttributeException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void loadFailed(String configuration, Exception problem) {
        for (int i = 0; i < this.configurations.length; ++i) {
            if (!this.configurations[i].equals(configuration)) continue;
            this.configStatus[i] = 120;
        }
        if (problem != null) {
            this.exceptions.add(problem);
        }
    }

    public synchronized void serverStartFailed(Exception problem) {
        this.currentOperation = "Startup failed";
        this.repaint();
        this.out.println();
        problem.printStackTrace(this.out);
    }

    public synchronized void startFailed(String configuration, Exception problem) {
        for (int i = 0; i < this.configurations.length; ++i) {
            if (!this.configurations[i].equals(configuration)) continue;
            this.configStatus[i] = 120;
        }
        if (problem != null) {
            this.exceptions.add(problem);
        }
    }

    private synchronized void repaint() {
        StringBuffer buf = new StringBuffer();
        buf.append("\r[");
        buf.append(this.kernel == null ? (char)' ' : '*');
        for (int i = 0; i < this.configStatus.length; ++i) {
            buf.append(this.configStatus[i]);
        }
        buf.append(this.finished ? (char)'*' : ' ');
        buf.append("] ");
        if (this.percent < 10) {
            buf.append(' ');
        }
        buf.append(this.percent).append("% ");
        int time = Math.round((float)(System.currentTimeMillis() - this.started) / 1000.0f);
        if (time < 10) {
            buf.append(' ');
        }
        if (time < 100) {
            buf.append(' ');
        }
        buf.append(time).append("s ");
        if (this.currentOperation.length() > this.operationLimit) {
            int space = this.currentOperation.indexOf(32);
            buf.append(this.currentOperation.substring(0, space + 1));
            buf.append("...").append(this.currentOperation.substring(this.currentOperation.length() - this.operationLimit + space + 4));
        } else {
            buf.append(this.currentOperation);
            for (int i = this.currentOperation.length(); i < this.operationLimit; ++i) {
                buf.append(' ');
            }
        }
        this.out.print(buf.toString());
        this.out.flush();
    }

    private static boolean isApplicationModule(ObjectName on) {
        String type = on.getKeyProperty("j2eeType");
        String app = on.getKeyProperty("J2EEApplication");
        String name = on.getKeyProperty("name");
        if (type != null && (app == null || app.equals("null"))) {
            return (type.equals("WebModule") || type.equals("J2EEModule") || type.equals("EJBModule") || type.equals("AppClientModule") || type.equals("ResourceAdapterModule")) && !name.startsWith("org/apache/geronimo/System");
        }
        return false;
    }

    private static String decodeModule(String value) {
        if (value.equals("WebModule")) {
            return "WAR";
        }
        if (value.equals("J2EEModule")) {
            return "EAR";
        }
        if (value.equals("EJBModule")) {
            return "JAR";
        }
        if (value.equals("AppClientModule")) {
            return "CAR";
        }
        if (value.equals("ResourceAdapterModule")) {
            return "RAR";
        }
        return "UNK";
    }

    private static String decamelize(String s) {
        if (s == null || s.equals("")) {
            return s;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(Character.toUpperCase(s.charAt(0)));
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isUpperCase(s.charAt(i)) && s.length() > i + 1 && Character.isLowerCase(s.charAt(i + 1))) {
                buf.append(" ");
            }
            buf.append(s.charAt(i));
        }
        return buf.toString();
    }

    private class UpdateThread
    extends Thread {
        private volatile boolean done;

        public UpdateThread() {
            super("Progress Display Update Thread");
            this.done = false;
            this.setDaemon(true);
        }

        public void run() {
            while (!this.done) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    continue;
                }
                ProgressBarStartupMonitor.this.repaint();
            }
            ProgressBarStartupMonitor.this.wrapUp();
        }
    }

    private static class AddressHolder
    implements Comparable {
        private String name;
        private InetSocketAddress address;

        public AddressHolder(String name, InetSocketAddress address) {
            this.name = name;
            this.address = address;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public InetSocketAddress getAddress() {
            return this.address;
        }

        public void setAddress(InetSocketAddress address) {
            this.address = address;
        }

        public int compareTo(Object o) {
            AddressHolder other = (AddressHolder)o;
            int value = this.address.getPort() - other.address.getPort();
            return value == 0 ? this.address.getAddress().toString().compareTo(other.address.getAddress().toString()) : value;
        }
    }
}

