/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.main;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.URLClassPath;

public class ToolsJarHack {
    private static boolean installed = false;
    private static Log log;
    static /* synthetic */ Class class$java$net$URLClassLoader;

    public static void install() {
        URL toolsJarURL;
        if (installed) {
            return;
        }
        if (log == null) {
            log = LogFactory.getLog((Class)ToolsJarHack.class);
        }
        ClassLoader myClassLoader = ToolsJarHack.class.getClassLoader();
        Class<?> compilerClass = null;
        try {
            compilerClass = myClassLoader.loadClass("sun.tools.javac.Main");
        }
        catch (ClassNotFoundException ignored) {
            // empty catch block
        }
        if (compilerClass != null) {
            installed = true;
            return;
        }
        File toolsJarFile = ToolsJarHack.findToolsJarFile();
        if (toolsJarFile == null) {
            return;
        }
        try {
            toolsJarURL = toolsJarFile.toURL();
        }
        catch (MalformedURLException e) {
            log.warn((Object)("Could not find java compiler: tools.jar file not a regular file: " + toolsJarFile.getAbsolutePath()), (Throwable)e);
            return;
        }
        ToolsJarHack.addJarToPath(toolsJarURL);
        installed = true;
    }

    private static File findToolsJarFile() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null) {
            return null;
        }
        File javaHomeDir = new File(javaHome);
        if (!javaHomeDir.isDirectory()) {
            return null;
        }
        File toolsJarFile = ToolsJarHack.findToolsJarFile(javaHomeDir);
        if (toolsJarFile != null) {
            return toolsJarFile;
        }
        toolsJarFile = ToolsJarHack.findToolsJarFile(javaHomeDir.getParentFile());
        if (toolsJarFile != null) {
            return toolsJarFile;
        }
        log.warn((Object)("Could not find java compiler: lib" + File.separator + "tools.jar file not found in " + javaHomeDir.getAbsolutePath() + " or " + javaHomeDir.getParentFile().getAbsolutePath()));
        return null;
    }

    private static File findToolsJarFile(File javaHomeDir) {
        File toolsJarFile = new File(javaHomeDir, "lib" + File.separator + "tools.jar");
        if (!toolsJarFile.exists()) {
            return null;
        }
        if (!toolsJarFile.isFile()) {
            return null;
        }
        return toolsJarFile;
    }

    private static void addJarToPath(URL jar) {
        URLClassLoader urlClassLoader = null;
        try {
            urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        }
        catch (Throwable e) {
            log.warn((Object)"Could not install compiler: Could not obtain access to system class loader", e);
            return;
        }
        URLClassPath urlClassPath = ToolsJarHack.getURLClassPath(urlClassLoader);
        if (urlClassPath == null) {
            return;
        }
        urlClassPath.addURL(jar);
        ToolsJarHack.rebuildJavaClassPathVariable(urlClassPath);
    }

    private static URLClassPath getURLClassPath(URLClassLoader loader) {
        Field ucpField = (Field)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Field ucp = null;
                try {
                    ucp = (class$java$net$URLClassLoader == null ? (class$java$net$URLClassLoader = ToolsJarHack.class$("java.net.URLClassLoader")) : class$java$net$URLClassLoader).getDeclaredField("ucp");
                    ucp.setAccessible(true);
                }
                catch (Exception e) {
                    log.warn((Object)"Could not install compiler: Could not obtain access to ucp field of the URLClassLoader", (Throwable)e);
                }
                return ucp;
            }
        });
        if (ucpField == null) {
            return null;
        }
        try {
            return (URLClassPath)ucpField.get(loader);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)"Could not install compiler: Could not obtain access to ucp field of the URLClassLoader", (Throwable)e);
            return null;
        }
    }

    private static void rebuildJavaClassPathVariable(URLClassPath urlClassPath) {
        URL[] urls = urlClassPath.getURLs();
        if (urls.length < 1) {
            return;
        }
        StringBuffer path = new StringBuffer(urls.length * 32);
        for (int i = 0; i < urls.length; ++i) {
            if (i != 0) {
                path.append(File.pathSeparator);
            }
            path.append(new File(urls[i].getFile()).getPath());
        }
        try {
            System.setProperty("java.class.path", path.toString());
        }
        catch (Exception e) {
            log.warn((Object)"Error installing compiler: Could not update java.class.path property which may cause compiler to not work correctly", (Throwable)e);
        }
    }
}

