/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.rmi;

import java.net.InetSocketAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.system.rmi.RMIClassLoaderSpiImpl;

public class RMIRegistryService
implements GBeanLifecycle {
    private static final Log log = LogFactory.getLog((Class)RMIRegistryService.class);
    private int port = 1099;
    private Registry registry;
    public static final GBeanInfo GBEAN_INFO;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void doStart() throws Exception {
        System.setProperty("java.rmi.server.RMIClassLoaderSpi", RMIClassLoaderSpiImpl.class.getName());
        this.registry = LocateRegistry.createRegistry(this.port);
        log.info((Object)("Started RMI Registry on port " + this.port));
    }

    public void doStop() throws Exception {
        UnicastRemoteObject.unexportObject(this.registry, true);
        log.info((Object)"Stopped RMI Registry");
    }

    public void doFail() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            log.warn((Object)"RMI Registry failed");
        }
    }

    public InetSocketAddress getAddress() {
        return new InetSocketAddress("0.0.0.0", this.getPort());
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder("RMI Naming", RMIRegistryService.class);
        infoFactory.addAttribute("port", Integer.TYPE, true);
        infoFactory.addAttribute("address", InetSocketAddress.class, false);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

