/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.serverinfo;

import java.io.File;
import java.net.URI;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.system.serverinfo.DirectoryUtils;
import org.apache.geronimo.system.serverinfo.ServerConstants;

public class ServerInfo {
    private final String baseDirectory;
    private final File base;
    private final URI baseURI;
    public static final GBeanInfo GBEAN_INFO;

    public ServerInfo() {
        this.baseDirectory = null;
        this.base = null;
        this.baseURI = null;
    }

    public ServerInfo(String baseDirectory) throws Exception {
        this.baseDirectory = baseDirectory;
        ServerConstants.getVersion();
        baseDirectory = System.getProperty("geronimo.base.dir", baseDirectory);
        if (baseDirectory == null || baseDirectory.length() == 0) {
            this.base = DirectoryUtils.getGeronimoInstallDirectory();
            if (this.base == null) {
                throw new IllegalArgumentException("Could not determine geronimo installation directory");
            }
        } else {
            this.base = new File(baseDirectory);
        }
        if (!this.base.isDirectory()) {
            throw new IllegalArgumentException("Base directory is not a directory: " + baseDirectory);
        }
        this.baseURI = this.base.toURI();
        System.setProperty("geronimo.base.dir", this.base.getAbsolutePath());
    }

    public String resolvePath(String filename) {
        return this.resolve(filename).getAbsolutePath();
    }

    public File resolve(String filename) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(this.base, filename);
    }

    public URI resolve(URI uri) {
        return this.baseURI.resolve(uri);
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public String getVersion() {
        return ServerConstants.getVersion();
    }

    public String getBuildDate() {
        return ServerConstants.getBuildDate();
    }

    public String getBuildTime() {
        return ServerConstants.getBuildTime();
    }

    public String getCopyright() {
        return ServerConstants.getCopyright();
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(ServerInfo.class);
        infoFactory.addAttribute("baseDirectory", String.class, true);
        infoFactory.addAttribute("version", String.class, false);
        infoFactory.addAttribute("buildDate", String.class, false);
        infoFactory.addAttribute("buildTime", String.class, false);
        infoFactory.addAttribute("copyright", String.class, false);
        infoFactory.addOperation("resolvePath", new Class[]{String.class});
        infoFactory.addOperation("resolve", new Class[]{String.class});
        infoFactory.addOperation("resolve", new Class[]{URI.class});
        infoFactory.setConstructor(new String[]{"baseDirectory"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

