/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.url;

import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.system.url.file.Handler;

public class GeronimoURLFactory
implements GBeanLifecycle {
    private static final URLStreamHandlerFactory factory = new URLStreamHandlerFactory();
    private static boolean installed = false;
    public static final GBeanInfo GBEAN_INFO;
    static /* synthetic */ Class class$java$net$URL;

    public void doStart() throws Exception {
        GeronimoURLFactory.install();
    }

    public void doStop() throws Exception {
    }

    public void doFail() {
    }

    public void registerHandler(String protocol, URLStreamHandler handler) {
        GeronimoURLFactory.factory.registerHandler(protocol, handler);
    }

    public URLStreamHandler getRegisteredHandler(String protocol) {
        return GeronimoURLFactory.factory.getRegisteredHandler(protocol);
    }

    public Map getRegisteredHandlers() {
        return GeronimoURLFactory.factory.getRegisteredHandlers();
    }

    public static boolean isInstalled() {
        return installed;
    }

    public static void install() throws Error, SecurityException {
        if (!installed) {
            URL.setURLStreamHandlerFactory(factory);
            installed = true;
        }
    }

    public static void forceInstall() throws Error, SecurityException {
        if (!installed) {
            Throwable t = (Throwable)AccessController.doPrivileged(new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    try {
                        Object streamHandlerLock;
                        Field streamHandlerLockField = (class$java$net$URL == null ? (class$java$net$URL = GeronimoURLFactory.class$("java.net.URL")) : class$java$net$URL).getDeclaredField("streamHandlerLock");
                        streamHandlerLockField.setAccessible(true);
                        Object object = streamHandlerLock = streamHandlerLockField.get(null);
                        synchronized (object) {
                            Field factoryField = (class$java$net$URL == null ? (class$java$net$URL = GeronimoURLFactory.class$("java.net.URL")) : class$java$net$URL).getDeclaredField("factory");
                            factoryField.setAccessible(true);
                            Field handlersField = (class$java$net$URL == null ? (class$java$net$URL = GeronimoURLFactory.class$("java.net.URL")) : class$java$net$URL).getDeclaredField("handlers");
                            handlersField.setAccessible(true);
                            Map handlers = (Map)handlersField.get(null);
                            factoryField.set(null, factory);
                            handlers.clear();
                        }
                    }
                    catch (Throwable e) {
                        return e;
                    }
                    return null;
                }
            });
            if (t != null) {
                if (t instanceof SecurityException) {
                    throw (SecurityException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new Error("Unknown error while force installing URL factory", t);
            }
            installed = true;
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(GeronimoURLFactory.class);
        infoFactory.addOperation("registerHandler", new Class[]{String.class, URLStreamHandler.class});
        infoFactory.addOperation("getRegisteredHandler", new Class[]{String.class});
        infoFactory.addOperation("getRegisteredHandlers", new Class[0]);
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private static class URLStreamHandlerFactory
    implements java.net.URLStreamHandlerFactory {
        private final Map handlers = new HashMap();
        private final List handlerPackages = new LinkedList();
        static final /* synthetic */ boolean $assertionsDisabled;

        private URLStreamHandlerFactory() {
            String systemPackages = System.getProperty("java.protocol.handler.pkgs");
            if (systemPackages != null) {
                StringTokenizer stok = new StringTokenizer(systemPackages, "|");
                while (stok.hasMoreTokens()) {
                    this.handlerPackages.add(stok.nextToken().trim());
                }
            }
            this.handlerPackages.add("sun.net.www.protocol");
            this.handlers.put("file", new Handler());
            this.handlers.put("resource", new org.apache.geronimo.system.url.resource.Handler());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URLStreamHandler createURLStreamHandler(String protocol) {
            URLStreamHandler handler;
            if (protocol == null) {
                throw new IllegalArgumentException("protocol is null");
            }
            protocol = protocol.trim();
            URLStreamHandlerFactory uRLStreamHandlerFactory = this;
            synchronized (uRLStreamHandlerFactory) {
                handler = (URLStreamHandler)this.handlers.get(protocol);
            }
            if (handler != null) {
                return handler;
            }
            Class type = this.findProtocolHandler(protocol);
            if (type == null) {
                throw new IllegalArgumentException("unknown protocol: " + protocol);
            }
            try {
                return (URLStreamHandler)type.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error constructing protocol handler:protocol " + protocol + " messgae=" + e.getMessage());
            }
        }

        private synchronized void registerHandler(String protocol, URLStreamHandler handler) {
            if (!$assertionsDisabled && protocol == null) {
                throw new AssertionError((Object)"protocol is null");
            }
            if (!$assertionsDisabled && handler == null) {
                throw new AssertionError((Object)"handler is null");
            }
            if (this.handlers.containsKey(protocol)) {
                throw new IllegalStateException("Protocol already has a registered handler: " + protocol);
            }
            this.handlers.put(protocol, handler);
        }

        private synchronized URLStreamHandler getRegisteredHandler(String protocol) {
            return (URLStreamHandler)this.handlers.get(protocol);
        }

        private synchronized Map getRegisteredHandlers() {
            return new HashMap(this.handlers);
        }

        private Class findProtocolHandler(String protocol) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            Iterator iterator = this.handlerPackages.iterator();
            while (iterator.hasNext()) {
                String pkg = (String)iterator.next();
                String classname = pkg + "." + protocol + ".Handler";
                try {
                    return classLoader.loadClass(classname);
                }
                catch (Throwable e) {
                }
            }
            return null;
        }

        static {
            $assertionsDisabled = !(class$org$apache$geronimo$system$url$GeronimoURLFactory == null ? (class$org$apache$geronimo$system$url$GeronimoURLFactory = GeronimoURLFactory.class$("org.apache.geronimo.system.url.GeronimoURLFactory")) : class$org$apache$geronimo$system$url$GeronimoURLFactory).desiredAssertionStatus();
        }
    }
}

