/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.url.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SyncFailedException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.net.www.ParseUtil;

public class FileURLConnection
extends URLConnection {
    private static final boolean IS_OS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private File file;
    private FileDescriptor fd;

    public FileURLConnection(URL url, File file) throws MalformedURLException, IOException {
        super(url);
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (!this.file.exists()) {
            throw new FileNotFoundException(this.file.toString());
        }
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        FileInputStream fis = new FileInputStream(this.file);
        this.fd = fis.getFD();
        return new BufferedInputStream(fis);
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        FileOutputStream fos = new FileOutputStream(this.file);
        this.fd = fos.getFD();
        return new BufferedOutputStream(fos);
    }

    public Permission getPermission() throws IOException {
        String perms = null;
        if (this.file.canRead()) {
            perms = "read";
        }
        if (this.file.canWrite()) {
            perms = perms != null ? perms + ",write" : "write";
        }
        String filename = ParseUtil.decode(this.url.getPath());
        if (File.separatorChar != '/') {
            filename.replace('/', File.separatorChar);
        }
        return new FilePermission(filename, perms);
    }

    private void maybeSync() {
        if (this.fd != null && this.fd.valid() && IS_OS_WINDOWS) {
            try {
                this.fd.sync();
            }
            catch (SyncFailedException syncFailedException) {
                // empty catch block
            }
        }
    }

    public long getLastModified() {
        this.maybeSync();
        return this.file.lastModified();
    }

    public long getDate() {
        return this.getLastModified();
    }

    public int getContentLength() {
        this.maybeSync();
        long value = this.file.length();
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            throw new IllegalStateException("Can not safly convert to int: " + value);
        }
        return (int)value;
    }

    public String getContentType() {
        return FileURLConnection.getFileNameMap().getContentTypeFor(this.file.getName());
    }

    public String getHeaderField(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        String headerName = name.toLowerCase();
        if (headerName.equals("last-modified")) {
            return String.valueOf(this.getLastModified());
        }
        if (headerName.equals("content-length")) {
            return String.valueOf(this.getContentLength());
        }
        if (headerName.equals("content-type")) {
            return this.getContentType();
        }
        if (headerName.equals("date")) {
            return String.valueOf(this.getDate());
        }
        return super.getHeaderField(name);
    }

    public Map getHeaderFields() {
        HashMap headers = new HashMap();
        String[] headerNames = new String[]{"last-modified", "content-length", "content-type", "date"};
        for (int i = 0; i < headerNames.length; ++i) {
            ArrayList<String> list = new ArrayList<String>(1);
            list.add(this.getHeaderField(headerNames[i]));
            headers.put(headerNames[i], Collections.unmodifiableList(list));
        }
        return Collections.unmodifiableMap(headers);
    }

    public String getHeaderFieldKey(int n) {
        return this.getHeaderFieldKey(n);
    }

    public String getHeaderField(int n) {
        return this.getHeaderField(n);
    }
}

