/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.system.url.resource;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.geronimo.system.url.DelegatingURLConnection;

public class ResourceURLConnection
extends DelegatingURLConnection {
    public ResourceURLConnection(URL url) throws MalformedURLException, IOException {
        super(url);
    }

    protected URL makeDelegateUrl(URL url) throws MalformedURLException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String name = url.getPath();
        URL target = null;
        String ref = url.getRef();
        if (ref != null) {
            try {
                Class<?> type = classLoader.loadClass(ref);
                target = type.getResource(name);
            }
            catch (ClassNotFoundException ignore) {
                // empty catch block
            }
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (target == null && (target = classLoader.getResource(name)) == null) {
            target = ClassLoader.getSystemClassLoader().getResource(name);
        }
        if (target == null) {
            throw new FileNotFoundException("Could not locate resource: " + name);
        }
        return target;
    }
}

