/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.context;

import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.transaction.context.BeanTransactionContext;
import org.apache.geronimo.transaction.context.ContainerTransactionContext;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.UnspecifiedTransactionContext;

public class TransactionContextManager {
    private final TransactionManager transactionManager;
    public static final GBeanInfo GBEAN_INFO;

    public TransactionContextManager() {
        this.transactionManager = null;
    }

    public TransactionContextManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionContext getContext() {
        return TransactionContext.getContext();
    }

    public void setContext(TransactionContext transactionContext) {
        TransactionContext.setContext(transactionContext);
    }

    public ContainerTransactionContext newContainerTransactionContext() throws NotSupportedException, SystemException {
        ContainerTransactionContext transactionContext = new ContainerTransactionContext(this.transactionManager);
        TransactionContext.setContext(transactionContext);
        transactionContext.begin();
        return transactionContext;
    }

    public BeanTransactionContext newBeanTransactionContext() throws NotSupportedException, SystemException {
        TransactionContext ctx = TransactionContext.getContext();
        if (!(ctx instanceof UnspecifiedTransactionContext)) {
            throw new NotSupportedException("Previous Transaction has not been committed");
        }
        UnspecifiedTransactionContext oldContext = (UnspecifiedTransactionContext)ctx;
        BeanTransactionContext transactionContext = new BeanTransactionContext(this.transactionManager, oldContext);
        oldContext.suspend();
        try {
            transactionContext.begin();
        }
        catch (SystemException e) {
            oldContext.resume();
            throw e;
        }
        catch (NotSupportedException e) {
            oldContext.resume();
            throw e;
        }
        TransactionContext.setContext(transactionContext);
        return transactionContext;
    }

    public UnspecifiedTransactionContext newUnspecifiedTransactionContext() {
        UnspecifiedTransactionContext transactionContext = new UnspecifiedTransactionContext();
        TransactionContext.setContext(transactionContext);
        return transactionContext;
    }

    public int getStatus() throws SystemException {
        return this.transactionManager.getStatus();
    }

    public void setRollbackOnly() throws SystemException {
        this.transactionManager.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.transactionManager.setTransactionTimeout(seconds);
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(TransactionContextManager.class);
        infoFactory.addOperation("getContext");
        infoFactory.addOperation("setContext", new Class[]{TransactionContext.class});
        infoFactory.addOperation("newContainerTransactionContext");
        infoFactory.addOperation("newBeanTransactionContext");
        infoFactory.addOperation("newUnspecifiedTransactionContext");
        infoFactory.addReference("TransactionManager", TransactionManager.class);
        infoFactory.setConstructor(new String[]{"TransactionManager"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

