/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoFactory;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.system.serverinfo.ServerInfo;
import org.apache.geronimo.transaction.manager.LogException;
import org.apache.geronimo.transaction.manager.Recovery;
import org.apache.geronimo.transaction.manager.TransactionBranchInfo;
import org.apache.geronimo.transaction.manager.TransactionBranchInfoImpl;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.InvalidLogKeyException;
import org.objectweb.howl.log.LogClosedException;
import org.objectweb.howl.log.LogConfigurationException;
import org.objectweb.howl.log.LogFileOverflowException;
import org.objectweb.howl.log.LogRecord;
import org.objectweb.howl.log.LogRecordSizeException;
import org.objectweb.howl.log.Logger;
import org.objectweb.howl.log.ReplayListener;

public class HOWLLog
implements TransactionLog,
GBeanLifecycle {
    static final byte PREPARE = 1;
    static final byte COMMIT = 2;
    static final byte ROLLBACK = 3;
    static final String[] TYPE_NAMES = new String[]{null, "PREPARE", "COMMIT", "ROLLBACK"};
    private static final Log log = LogFactory.getLog((Class)HOWLLog.class);
    private final ServerInfo serverInfo;
    private String logFileDir;
    private final Logger logger;
    private final Configuration configuration = new Configuration();
    private boolean started = false;
    private final SortedSet marks = new TreeSet();
    public static final GBeanInfo GBEAN_INFO;

    public HOWLLog(String bufferClassName, int bufferSize, boolean checksumEnabled, int flushSleepTimeMilliseconds, String logFileDir, String logFileExt, String logFileName, int maxBlocksPerFile, int maxBuffers, int maxLogFiles, int minBuffers, int threadsWaitingForceThreshold, ServerInfo serverInfo) throws IOException {
        this.serverInfo = serverInfo;
        this.setBufferClassName(bufferClassName);
        this.setBufferSizeKBytes(bufferSize);
        this.setChecksumEnabled(checksumEnabled);
        this.setFlushSleepTimeMilliseconds(flushSleepTimeMilliseconds);
        this.logFileDir = logFileDir;
        this.setLogFileExt(logFileExt);
        this.setLogFileName(logFileName);
        this.setMaxBlocksPerFile(maxBlocksPerFile);
        this.setMaxBuffers(maxBuffers);
        this.setMaxLogFiles(maxLogFiles);
        this.setMinBuffers(minBuffers);
        this.setThreadsWaitingForceThreshold(threadsWaitingForceThreshold);
        this.logger = new Logger(this.configuration);
    }

    public String getLogFileDir() {
        return this.logFileDir;
    }

    public void setLogFileDir(String logDir) {
        this.logFileDir = logDir;
        if (this.started) {
            this.configuration.setLogFileDir(this.serverInfo.resolvePath(logDir));
        }
    }

    public String getLogFileExt() {
        return this.configuration.getLogFileExt();
    }

    public void setLogFileExt(String logFileExt) {
        this.configuration.setLogFileExt(logFileExt);
    }

    public String getLogFileName() {
        return this.configuration.getLogFileName();
    }

    public void setLogFileName(String logFileName) {
        this.configuration.setLogFileName(logFileName);
    }

    public boolean isChecksumEnabled() {
        return this.configuration.isChecksumEnabled();
    }

    public void setChecksumEnabled(boolean checksumOption) {
        this.configuration.setChecksumEnabled(checksumOption);
    }

    public int getBufferSizeKBytes() {
        return this.configuration.getBufferSize();
    }

    public void setBufferSizeKBytes(int bufferSize) {
        this.configuration.setBufferSize(bufferSize);
    }

    public String getBufferClassName() {
        return this.configuration.getBufferClassName();
    }

    public void setBufferClassName(String bufferClassName) {
        this.configuration.setBufferClassName(bufferClassName);
    }

    public int getMaxBuffers() {
        return this.configuration.getMaxBuffers();
    }

    public void setMaxBuffers(int maxBuffers) {
        this.configuration.setMaxBuffers(maxBuffers);
    }

    public int getMinBuffers() {
        return this.configuration.getMinBuffers();
    }

    public void setMinBuffers(int minBuffers) {
        this.configuration.setMinBuffers(minBuffers);
    }

    public int getFlushSleepTimeMilliseconds() {
        return this.configuration.getFlushSleepTime();
    }

    public void setFlushSleepTimeMilliseconds(int flushSleepTime) {
        this.configuration.setFlushSleepTime(flushSleepTime);
    }

    public int getThreadsWaitingForceThreshold() {
        return this.configuration.getThreadsWaitingForceThreshold();
    }

    public void setThreadsWaitingForceThreshold(int threadsWaitingForceThreshold) {
        this.configuration.setThreadsWaitingForceThreshold(threadsWaitingForceThreshold == -1 ? Integer.MAX_VALUE : threadsWaitingForceThreshold);
    }

    public int getMaxBlocksPerFile() {
        return this.configuration.getMaxBlocksPerFile();
    }

    public void setMaxBlocksPerFile(int maxBlocksPerFile) {
        this.configuration.setMaxBlocksPerFile(maxBlocksPerFile == -1 ? Integer.MAX_VALUE : maxBlocksPerFile);
    }

    public int getMaxLogFiles() {
        return this.configuration.getMaxLogFiles();
    }

    public void setMaxLogFiles(int maxLogFiles) {
        this.configuration.setMaxLogFiles(maxLogFiles);
    }

    public ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    public void doStart() throws WaitingException, Exception {
        this.started = true;
        this.setLogFileDir(this.logFileDir);
        this.logger.open();
    }

    public void doStop() throws WaitingException, Exception {
        this.started = false;
        this.logger.close();
    }

    public void doFail() {
    }

    public void begin(Xid xid) throws LogException {
    }

    public long prepare(Xid xid, List branches) throws LogException {
        int branchCount = branches.size();
        byte[][] data = new byte[4 + 2 * branchCount][];
        data[0] = new byte[]{1};
        data[1] = this.intToBytes(xid.getFormatId());
        data[2] = xid.getGlobalTransactionId();
        data[3] = xid.getBranchQualifier();
        int i = 4;
        Iterator iterator = branches.iterator();
        while (iterator.hasNext()) {
            TransactionBranchInfo transactionBranchInfo = (TransactionBranchInfo)iterator.next();
            data[i++] = transactionBranchInfo.getBranchXid().getBranchQualifier();
            data[i++] = transactionBranchInfo.getResourceName().getBytes();
        }
        try {
            long logMark = this.logger.put((byte[][])data, true);
            this.addMark(logMark);
            return logMark;
        }
        catch (LogClosedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogRecordSizeException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogFileOverflowException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (InterruptedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (IOException e) {
            throw new LogException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMark(long logMark) {
        SortedSet sortedSet = this.marks;
        synchronized (sortedSet) {
            this.marks.add(new Long(logMark));
        }
    }

    public void commit(Xid xid, long logMark) throws LogException {
        byte[][] data = new byte[][]{{2}, this.intToBytes(xid.getFormatId()), xid.getGlobalTransactionId(), xid.getBranchQualifier()};
        try {
            this.logger.put((byte[][])data, false);
            boolean doMark = this.removeMark(logMark);
            if (doMark) {
                this.logger.mark(logMark);
            }
        }
        catch (LogClosedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogRecordSizeException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogFileOverflowException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (InterruptedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (IOException e) {
            throw new LogException(e);
        }
        catch (InvalidLogKeyException e) {
            throw new LogException(e);
        }
    }

    public void rollback(Xid xid, long logMark) throws LogException {
        byte[][] data = new byte[][]{{3}, this.intToBytes(xid.getFormatId()), xid.getGlobalTransactionId(), xid.getBranchQualifier()};
        try {
            this.logger.put((byte[][])data, false);
            boolean doMark = this.removeMark(logMark);
            if (doMark) {
                this.logger.mark(logMark);
            }
        }
        catch (LogClosedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogRecordSizeException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (LogFileOverflowException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (InterruptedException e) {
            throw (IllegalStateException)new IllegalStateException().initCause(e);
        }
        catch (IOException e) {
            throw new LogException(e);
        }
        catch (InvalidLogKeyException e) {
            throw new LogException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMark(long logMark) {
        boolean doMark = false;
        Long mark = new Long(logMark);
        SortedSet sortedSet = this.marks;
        synchronized (sortedSet) {
            doMark = mark.equals(this.marks.first());
            this.marks.remove(mark);
        }
        return doMark;
    }

    public Collection recover(XidFactory xidFactory) throws LogException {
        log.info((Object)"Initiating transaction manager recovery");
        HashMap recovered = new HashMap();
        GeronimoReplayListener replayListener = new GeronimoReplayListener(xidFactory, recovered);
        try {
            this.logger.replay((ReplayListener)replayListener);
        }
        catch (LogConfigurationException e) {
            throw new LogException(e);
        }
        log.info((Object)"In doubt transactions recovered from log");
        return recovered.values();
    }

    public String getXMLStats() {
        return this.logger.getStats();
    }

    public int getAverageForceTime() {
        return 0;
    }

    public int getAverageBytesPerForce() {
        return 0;
    }

    private byte[] intToBytes(int formatId) {
        byte[] buffer = new byte[]{(byte)(formatId >> 24), (byte)(formatId >> 16), (byte)(formatId >> 8), (byte)(formatId >> 0)};
        return buffer;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        GBeanInfoFactory infoFactory = new GBeanInfoFactory(HOWLLog.class);
        infoFactory.addAttribute("bufferClassName", String.class, true);
        infoFactory.addAttribute("bufferSizeKBytes", Integer.TYPE, true);
        infoFactory.addAttribute("checksumEnabled", Boolean.TYPE, true);
        infoFactory.addAttribute("flushSleepTimeMilliseconds", Integer.TYPE, true);
        infoFactory.addAttribute("logFileDir", String.class, true);
        infoFactory.addAttribute("logFileExt", String.class, true);
        infoFactory.addAttribute("logFileName", String.class, true);
        infoFactory.addAttribute("maxBlocksPerFile", Integer.TYPE, true);
        infoFactory.addAttribute("maxBuffers", Integer.TYPE, true);
        infoFactory.addAttribute("maxLogFiles", Integer.TYPE, true);
        infoFactory.addAttribute("minBuffers", Integer.TYPE, true);
        infoFactory.addAttribute("threadsWaitingForceThreshold", Integer.TYPE, true);
        infoFactory.addReference("serverInfo", ServerInfo.class);
        infoFactory.addInterface(TransactionLog.class);
        infoFactory.setConstructor(new String[]{"bufferClassName", "bufferSizeKBytes", "checksumEnabled", "flushSleepTimeMilliseconds", "logFileDir", "logFileExt", "logFileName", "maxBlocksPerFile", "maxBuffers", "maxLogFiles", "minBuffers", "threadsWaitingForceThreshold", "serverInfo"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    private class GeronimoReplayListener
    implements ReplayListener {
        private final XidFactory xidFactory;
        private final Map recoveredTx;
        static final /* synthetic */ boolean $assertionsDisabled;

        public GeronimoReplayListener(XidFactory xidFactory, Map recoveredTx) {
            this.xidFactory = xidFactory;
            this.recoveredTx = recoveredTx;
        }

        public void onRecord(LogRecord lr) {
            short recordType = lr.type;
            long logMark = lr.key;
            if (recordType == 0) {
                ByteBuffer raw = lr.dataBuffer;
                if (raw.remaining() == 0) {
                    log.warn((Object)"Received empty log record of user type!");
                    return;
                }
                short size = raw.getShort();
                if (!$assertionsDisabled && size != 1) {
                    throw new AssertionError();
                }
                byte type = raw.get();
                size = raw.getShort();
                if (!$assertionsDisabled && size != 4) {
                    throw new AssertionError();
                }
                int formatId = raw.getInt();
                short globalIdLength = raw.getShort();
                byte[] globalId = new byte[globalIdLength];
                raw.get(globalId);
                short branchIdLength = raw.getShort();
                byte[] branchId = new byte[branchIdLength];
                raw.get(branchId);
                Xid masterXid = this.xidFactory.recover(formatId, globalId, branchId);
                if (type == 1) {
                    Recovery.XidBranchesPair xidBranchesPair = new Recovery.XidBranchesPair(masterXid, logMark);
                    this.recoveredTx.put(masterXid, xidBranchesPair);
                    HOWLLog.this.addMark(logMark);
                    while (raw.hasRemaining()) {
                        short branchBranchIdLength = raw.getShort();
                        byte[] branchBranchId = new byte[branchBranchIdLength];
                        raw.get(branchBranchId);
                        Xid branchXid = this.xidFactory.recover(formatId, globalId, branchBranchId);
                        short nameLength = raw.getShort();
                        byte[] nameBytes = new byte[nameLength];
                        raw.get(nameBytes);
                        String name = new String(nameBytes);
                        TransactionBranchInfoImpl branchInfo = new TransactionBranchInfoImpl(branchXid, name);
                        xidBranchesPair.addBranch(branchInfo);
                    }
                } else if (type == 2 || type == 3) {
                    this.recoveredTx.remove(masterXid);
                    HOWLLog.this.removeMark(logMark);
                } else {
                    log.error((Object)("Unknown recovery record received, type byte: " + type + ", buffer: " + raw));
                }
            } else if (recordType != 17408 && recordType != 19983) {
                log.warn((Object)("Received unexpected log record: " + lr));
            }
        }

        public void onError(org.objectweb.howl.log.LogException exception) {
            log.error((Object)"Error during recovery: ", (Throwable)exception);
        }

        public LogRecord getLogRecord() {
            return new LogRecord(1280);
        }

        static {
            $assertionsDisabled = !(class$org$apache$geronimo$transaction$log$HOWLLog == null ? (class$org$apache$geronimo$transaction$log$HOWLLog = HOWLLog.class$("org.apache.geronimo.transaction.log.HOWLLog")) : class$org$apache$geronimo$transaction$log$HOWLLog).desiredAssertionStatus();
        }
    }
}

