/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.gbean.GBeanLifecycle;
import org.apache.geronimo.gbean.ReferenceCollection;
import org.apache.geronimo.gbean.ReferenceCollectionEvent;
import org.apache.geronimo.gbean.ReferenceCollectionListener;
import org.apache.geronimo.gbean.WaitingException;
import org.apache.geronimo.transaction.ExtendedTransactionManager;
import org.apache.geronimo.transaction.manager.NamedXAResource;
import org.apache.geronimo.transaction.manager.Recovery;
import org.apache.geronimo.transaction.manager.ResourceManager;
import org.apache.geronimo.transaction.manager.XidImporter;

public class TransactionManagerProxy
implements ExtendedTransactionManager,
XidImporter,
Recovery,
GBeanLifecycle {
    private static final Log recoveryLog;
    private final ExtendedTransactionManager delegate;
    private final XidImporter importer;
    private final Recovery recovery;
    private final ReferenceCollection resourceManagers;
    private List recoveryErrors = new ArrayList();
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TransactionManagerProxy(ExtendedTransactionManager delegate, XidImporter importer, Recovery recovery, Collection resourceManagers) {
        if (!$assertionsDisabled && delegate == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && importer == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && recovery == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resourceManagers == null) {
            throw new AssertionError();
        }
        this.delegate = delegate;
        this.importer = importer;
        this.recovery = recovery;
        this.resourceManagers = (ReferenceCollection)resourceManagers;
    }

    public TransactionManagerProxy(ConstructorParams params) {
        this(params.delegate, params.xidImporter, params.recovery, (Collection)params.resourceManagers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStart() throws WaitingException, Exception {
        this.recovery.recoverLog();
        ArrayList copy = null;
        ReferenceCollection referenceCollection = this.resourceManagers;
        synchronized (referenceCollection) {
            copy = new ArrayList(this.resourceManagers);
            this.resourceManagers.addReferenceCollectionListener(new ReferenceCollectionListener(){

                public void memberAdded(ReferenceCollectionEvent event) {
                    ResourceManager resourceManager = (ResourceManager)event.getMember();
                    TransactionManagerProxy.this.recoverResourceManager(resourceManager);
                }

                public void memberRemoved(ReferenceCollectionEvent event) {
                }
            });
        }
        Iterator iterator = copy.iterator();
        while (iterator.hasNext()) {
            ResourceManager resourceManager = (ResourceManager)iterator.next();
            this.recoverResourceManager(resourceManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverResourceManager(ResourceManager resourceManager) {
        NamedXAResource namedXAResource = null;
        try {
            namedXAResource = resourceManager.getRecoveryXAResources();
        }
        catch (SystemException e) {
            recoveryLog.error((Object)e);
            this.recoveryErrors.add(e);
            return;
        }
        if (namedXAResource != null) {
            try {
                this.recovery.recoverResourceManager(namedXAResource);
            }
            catch (XAException e) {
                recoveryLog.error((Object)e);
                this.recoveryErrors.add(e);
            }
            finally {
                resourceManager.returnResource(namedXAResource);
            }
        }
    }

    public void doStop() throws WaitingException, Exception {
    }

    public void doFail() {
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.delegate.setTransactionTimeout(timeout);
    }

    public Transaction begin(long transactionTimeoutMilliseconds) throws NotSupportedException, SystemException {
        Transaction tx = this.delegate.begin(transactionTimeoutMilliseconds);
        return tx;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(0L);
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public Transaction getTransaction() throws SystemException {
        return this.delegate.getTransaction();
    }

    public Transaction suspend() throws SystemException {
        return this.delegate.suspend();
    }

    public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
        this.delegate.resume(tx);
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.delegate.commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.delegate.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.delegate.setRollbackOnly();
    }

    public Transaction importXid(Xid xid, long transactionTimeoutMillis) throws XAException, SystemException {
        Transaction tx = this.importer.importXid(xid, transactionTimeoutMillis);
        return tx;
    }

    public void commit(Transaction tx, boolean onePhase) throws XAException {
        this.importer.commit(tx, onePhase);
    }

    public void forget(Transaction tx) throws XAException {
        this.importer.forget(tx);
    }

    public int prepare(Transaction tx) throws XAException {
        return this.importer.prepare(tx);
    }

    public void rollback(Transaction tx) throws XAException {
        this.importer.rollback(tx);
    }

    public void recoverLog() throws XAException {
        throw new IllegalStateException("Don't call this");
    }

    public void recoverResourceManager(NamedXAResource xaResource) throws XAException {
        throw new IllegalStateException("Don't call this");
    }

    public boolean hasRecoveryErrors() {
        throw new IllegalStateException("Don't call this");
    }

    public List getRecoveryErrors() {
        throw new IllegalStateException("Don't call this");
    }

    public boolean localRecoveryComplete() {
        throw new IllegalStateException("Don't call this");
    }

    public int localUnrecoveredCount() {
        throw new IllegalStateException("Don't call this");
    }

    public Map getExternalXids() {
        Map internal = this.recovery.getExternalXids();
        HashMap external = new HashMap(internal.size());
        Iterator iterator = internal.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Transaction tx = (Transaction)entry.getValue();
            external.put(entry.getKey(), tx);
        }
        return external;
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !TransactionManagerProxy.class.desiredAssertionStatus();
        recoveryLog = LogFactory.getLog((String)"RecoveryController");
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(TransactionManagerProxy.class);
        infoFactory.addReference("delegate", ExtendedTransactionManager.class);
        infoFactory.addReference("xidImporter", XidImporter.class);
        infoFactory.addReference("recovery", Recovery.class);
        infoFactory.addReference("resourceManagers", ResourceManager.class);
        infoFactory.addInterface(ExtendedTransactionManager.class);
        infoFactory.addInterface(XidImporter.class);
        infoFactory.setConstructor(new String[]{"delegate", "xidImporter", "recovery", "resourceManagers"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }

    public static class ConstructorParams {
        ExtendedTransactionManager delegate;
        XidImporter xidImporter;
        Recovery recovery;
        ReferenceCollection resourceManagers;
    }
}

