/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction;

import java.io.Serializable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import org.apache.geronimo.transaction.OnlineUserTransaction;
import org.apache.geronimo.transaction.TrackedConnectionAssociator;
import org.apache.geronimo.transaction.context.TransactionContextManager;

public class UserTransactionImpl
implements UserTransaction,
Serializable {
    private final ThreadLocal state = new StateThreadLocal();
    private final OnlineUserTransaction ONLINE = new OnlineUserTransaction();
    private static final UserTransaction OFFLINE;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UserTransactionImpl() {
        this.state.set(OFFLINE);
    }

    public void setUp(TransactionContextManager transactionContextManager, TrackedConnectionAssociator trackedConnectionAssociator) {
        if (!$assertionsDisabled && this.isOnline()) {
            throw new AssertionError((Object)"Only set the tx manager when UserTransaction is offline");
        }
        this.ONLINE.setUp(transactionContextManager, trackedConnectionAssociator);
    }

    public boolean isOnline() {
        return this.state.get() == this.ONLINE;
    }

    public void setOnline(boolean online) {
        if (!$assertionsDisabled && online && !this.ONLINE.isActive()) {
            throw new AssertionError((Object)"online requires a tx manager");
        }
        this.state.set(online ? this.ONLINE : OFFLINE);
    }

    private UserTransaction getUserTransaction() {
        return (UserTransaction)this.state.get();
    }

    public void begin() throws NotSupportedException, SystemException {
        this.getUserTransaction().begin();
    }

    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        this.getUserTransaction().commit();
    }

    public int getStatus() throws SystemException {
        return this.getUserTransaction().getStatus();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        this.getUserTransaction().rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getUserTransaction().setRollbackOnly();
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        this.getUserTransaction().setTransactionTimeout(timeout);
    }

    static {
        $assertionsDisabled = !UserTransactionImpl.class.desiredAssertionStatus();
        OFFLINE = new OfflineUserTransaction();
    }

    private static final class OfflineUserTransaction
    implements UserTransaction,
    Serializable {
        private OfflineUserTransaction() {
        }

        public void begin() throws NotSupportedException, SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }

        public int getStatus() throws SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            throw new IllegalStateException("Cannot use UserTransaction methods in this state");
        }
    }

    private static class StateThreadLocal
    extends ThreadLocal
    implements Serializable {
        private StateThreadLocal() {
        }

        protected Object initialValue() {
            return OFFLINE;
        }
    }
}

