/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.context;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.geronimo.transaction.ExtendedTransactionManager;
import org.apache.geronimo.transaction.context.InheritableTransactionContext;
import org.apache.geronimo.transaction.context.UnspecifiedTransactionContext;

public class BeanTransactionContext
extends InheritableTransactionContext {
    private final ExtendedTransactionManager txnManager;
    private final UnspecifiedTransactionContext oldContext;
    private Transaction transaction;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BeanTransactionContext(ExtendedTransactionManager txnManager, UnspecifiedTransactionContext oldContext) {
        this.txnManager = txnManager;
        this.oldContext = oldContext;
    }

    public UnspecifiedTransactionContext getOldContext() {
        return this.oldContext;
    }

    public void begin(long transactionTimeoutMilliseconds) throws SystemException, NotSupportedException {
        this.transaction = this.txnManager.begin(transactionTimeoutMilliseconds);
    }

    public void suspend() throws SystemException {
        Transaction suspendedTransaction = this.txnManager.suspend();
        if (!$assertionsDisabled && this.transaction != suspendedTransaction) {
            throw new AssertionError((Object)"suspend did not return our transaction");
        }
    }

    public void resume() throws SystemException, InvalidTransactionException {
        this.txnManager.resume(this.transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
        try {
            try {
                this.flushState();
            }
            catch (Throwable t) {
                try {
                    this.txnManager.rollback();
                }
                catch (Throwable t1) {
                    log.error((Object)"Unable to roll back transaction", t1);
                }
                throw (RollbackException)new RollbackException("Could not flush state before commit").initCause(t);
            }
            this.txnManager.commit();
        }
        finally {
            this.connectorAfterCommit();
            this.transaction = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SystemException {
        try {
            this.txnManager.rollback();
        }
        finally {
            this.connectorAfterCommit();
            this.transaction = null;
        }
    }

    public boolean isActive() {
        try {
            return this.txnManager.getStatus() == 0;
        }
        catch (SystemException e) {
            return false;
        }
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    static {
        $assertionsDisabled = !BeanTransactionContext.class.desiredAssertionStatus();
    }
}

