/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.transaction.ConnectionReleaser;
import org.apache.geronimo.transaction.DoubleKeyedHashMap;
import org.apache.geronimo.transaction.InstanceContext;
import org.tranql.cache.InTxCache;

public abstract class TransactionContext {
    protected static final Log log = LogFactory.getLog((Class)TransactionContext.class);
    private static ThreadLocal CONTEXT = new ThreadLocal();
    private InstanceContext currentContext;
    private final DoubleKeyedHashMap associatedContexts = new DoubleKeyedHashMap();
    private final DoubleKeyedHashMap dirtyContexts = new DoubleKeyedHashMap();
    private Map managedConnections;
    private InTxCache inTxCache;

    public static TransactionContext getContext() {
        return (TransactionContext)CONTEXT.get();
    }

    public static void setContext(TransactionContext context) {
        CONTEXT.set(context);
    }

    public abstract void suspend() throws SystemException;

    public abstract void resume() throws SystemException, InvalidTransactionException;

    public abstract void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException;

    public abstract void rollback() throws SystemException;

    public final void associate(InstanceContext context) throws Throwable {
        if (this.associatedContexts.put(context.getContainerId(), context.getId(), context) == null) {
            context.associate();
        }
    }

    public final void unassociate(Object containerId, Object id) throws Exception {
        this.associatedContexts.remove(containerId, id);
        this.dirtyContexts.remove(containerId, id);
    }

    public final InstanceContext beginInvocation(InstanceContext context) {
        if (context.getId() != null) {
            this.dirtyContexts.put(context.getContainerId(), context.getId(), context);
        }
        InstanceContext caller = this.currentContext;
        this.currentContext = context;
        return caller;
    }

    public final void endInvocation(InstanceContext caller) {
        this.currentContext = caller;
    }

    public final void flushState() throws Throwable {
        while (!this.dirtyContexts.isEmpty()) {
            ArrayList toFlush = new ArrayList(this.dirtyContexts.values());
            this.dirtyContexts.clear();
            Iterator i = toFlush.iterator();
            while (i.hasNext()) {
                InstanceContext context = (InstanceContext)i.next();
                context.flush();
            }
        }
        if (this.currentContext != null && this.currentContext.getId() != null) {
            this.dirtyContexts.put(this.currentContext.getContainerId(), this.currentContext.getId(), this.currentContext);
        }
        if (this.inTxCache != null) {
            this.inTxCache.flush();
        }
    }

    protected void beforeCommit() throws Exception {
        ArrayList toFlush = new ArrayList(this.associatedContexts.values());
        Iterator i = toFlush.iterator();
        while (i.hasNext()) {
            InstanceContext context = (InstanceContext)i.next();
            context.beforeCommit();
        }
    }

    protected void afterCommit(boolean status) throws Exception {
        Throwable firstThrowable = null;
        ArrayList toFlush = new ArrayList(this.associatedContexts.values());
        Iterator i = toFlush.iterator();
        while (i.hasNext()) {
            InstanceContext context = (InstanceContext)i.next();
            try {
                context.afterCommit(status);
            }
            catch (Throwable e) {
                if (firstThrowable != null) continue;
                firstThrowable = e;
            }
        }
        if (firstThrowable instanceof Error) {
            throw (Error)firstThrowable;
        }
        if (firstThrowable instanceof Exception) {
            throw (Exception)firstThrowable;
        }
        if (firstThrowable != null) {
            throw (SystemException)new SystemException().initCause(firstThrowable);
        }
    }

    public final InstanceContext getContext(Object containerId, Object id) {
        return (InstanceContext)this.associatedContexts.get(containerId, id);
    }

    public final void setInTxCache(InTxCache inTxCache) {
        this.inTxCache = inTxCache;
    }

    public final InTxCache getInTxCache() {
        return this.inTxCache;
    }

    public void setManagedConnectionInfo(ConnectionReleaser key, Object info) {
        if (this.managedConnections == null) {
            this.managedConnections = new HashMap();
        }
        this.managedConnections.put(key, info);
    }

    public Object getManagedConnectionInfo(ConnectionReleaser key) {
        if (this.managedConnections == null) {
            return null;
        }
        return this.managedConnections.get(key);
    }

    public abstract boolean isActive();

    public abstract Transaction getTransaction();

    protected void connectorAfterCommit() {
        if (this.managedConnections != null) {
            Iterator entries = this.managedConnections.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                ConnectionReleaser key = (ConnectionReleaser)entry.getKey();
                key.afterCompletion(entry.getValue());
            }
            this.managedConnections.clear();
        }
    }
}

