/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.context;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.resource.spi.XATerminator;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.gbean.GBeanInfo;
import org.apache.geronimo.gbean.GBeanInfoBuilder;
import org.apache.geronimo.transaction.ExtendedTransactionManager;
import org.apache.geronimo.transaction.ImportedTransactionActiveException;
import org.apache.geronimo.transaction.XAWork;
import org.apache.geronimo.transaction.context.BeanTransactionContext;
import org.apache.geronimo.transaction.context.ContainerTransactionContext;
import org.apache.geronimo.transaction.context.TransactionContext;
import org.apache.geronimo.transaction.context.UnspecifiedTransactionContext;
import org.apache.geronimo.transaction.manager.Recovery;
import org.apache.geronimo.transaction.manager.XidImporter;

public class TransactionContextManager
implements XATerminator,
XAWork {
    private static final boolean NOT_IN_RECOVERY = false;
    private static final boolean IN_RECOVERY = true;
    private final ExtendedTransactionManager transactionManager;
    private final XidImporter importer;
    private final Recovery recovery;
    private final Map importedTransactions = new HashMap();
    private boolean recoveryState = false;
    public static final GBeanInfo GBEAN_INFO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TransactionContextManager() {
        this(null, null, null);
    }

    public TransactionContextManager(ExtendedTransactionManager transactionManager, XidImporter importer, Recovery recovery) {
        this.transactionManager = transactionManager;
        this.importer = importer;
        this.recovery = recovery;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionTimeout(int timeoutSeconds) throws SystemException {
        this.transactionManager.setTransactionTimeout(timeoutSeconds);
    }

    public TransactionContext getContext() {
        return TransactionContext.getContext();
    }

    public void setContext(TransactionContext transactionContext) {
        TransactionContext.setContext(transactionContext);
    }

    public ContainerTransactionContext newContainerTransactionContext() throws NotSupportedException, SystemException {
        ContainerTransactionContext transactionContext = new ContainerTransactionContext(this.transactionManager);
        TransactionContext.setContext(transactionContext);
        return transactionContext;
    }

    public BeanTransactionContext newBeanTransactionContext(long transactionTimeoutMilliseconds) throws NotSupportedException, SystemException {
        TransactionContext ctx = TransactionContext.getContext();
        if (!(ctx instanceof UnspecifiedTransactionContext)) {
            throw new NotSupportedException("Previous Transaction has not been committed");
        }
        UnspecifiedTransactionContext oldContext = (UnspecifiedTransactionContext)ctx;
        BeanTransactionContext transactionContext = new BeanTransactionContext(this.transactionManager, oldContext);
        oldContext.suspend();
        try {
            transactionContext.begin(transactionTimeoutMilliseconds);
        }
        catch (SystemException e) {
            oldContext.resume();
            throw e;
        }
        catch (NotSupportedException e) {
            oldContext.resume();
            throw e;
        }
        TransactionContext.setContext(transactionContext);
        return transactionContext;
    }

    public UnspecifiedTransactionContext newUnspecifiedTransactionContext() {
        UnspecifiedTransactionContext transactionContext = new UnspecifiedTransactionContext();
        TransactionContext.setContext(transactionContext);
        return transactionContext;
    }

    public int getStatus() throws SystemException {
        return this.transactionManager.getStatus();
    }

    public void setRollbackOnly() throws SystemException {
        this.transactionManager.setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        ContainerTransactionContext containerTransactionContext;
        Map map = this.importedTransactions;
        synchronized (map) {
            containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.remove(xid);
        }
        if (containerTransactionContext == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        try {
            int status = containerTransactionContext.getTransaction().getStatus();
            if (!$assertionsDisabled && status != 0 && status != 2) {
                throw new AssertionError();
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        this.importer.commit(containerTransactionContext.getTransaction(), onePhase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(Xid xid) throws XAException {
        ContainerTransactionContext containerTransactionContext;
        Map map = this.importedTransactions;
        synchronized (map) {
            containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.remove(xid);
        }
        if (containerTransactionContext == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        this.importer.forget(containerTransactionContext.getTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare(Xid xid) throws XAException {
        ContainerTransactionContext containerTransactionContext;
        Map map = this.importedTransactions;
        synchronized (map) {
            containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.get(xid);
        }
        if (containerTransactionContext == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        Transaction tx = containerTransactionContext.getTransaction();
        try {
            int status = tx.getStatus();
            if (!$assertionsDisabled && status != 0) {
                throw new AssertionError();
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        return this.importer.prepare(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xid[] recover(int flag) throws XAException {
        if (!this.recoveryState) {
            if ((flag & 0x1000000) == 0) {
                throw new XAException(-6);
            }
            this.recoveryState = true;
        }
        if ((flag & 0x800000) != 0) {
            this.recoveryState = false;
        }
        if ((flag & 0x1000000) != 0) {
            Map recoveredXidMap = this.recovery.getExternalXids();
            Xid[] recoveredXids = new Xid[recoveredXidMap.size()];
            int i = 0;
            Map map = this.importedTransactions;
            synchronized (map) {
                Iterator iterator = recoveredXidMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Xid xid = (Xid)entry.getKey();
                    recoveredXids[i++] = xid;
                    ContainerTransactionContext containerTransactionContext = new ContainerTransactionContext(this.transactionManager, (Transaction)entry.getValue());
                    this.importedTransactions.put(xid, containerTransactionContext);
                }
            }
            return recoveredXids;
        }
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        ContainerTransactionContext containerTransactionContext;
        Map map = this.importedTransactions;
        synchronized (map) {
            containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.remove(xid);
        }
        if (containerTransactionContext == null) {
            throw new XAException("No imported transaction for xid: " + xid);
        }
        Transaction tx = containerTransactionContext.getTransaction();
        try {
            int status = tx.getStatus();
            if (!$assertionsDisabled && status != 0 && status != 2) {
                throw new AssertionError();
            }
        }
        catch (SystemException e) {
            throw new XAException();
        }
        this.importer.rollback(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(Xid xid, long txTimeoutMillis) throws XAException, InvalidTransactionException, SystemException, ImportedTransactionActiveException {
        ContainerTransactionContext containerTransactionContext;
        Map map = this.importedTransactions;
        synchronized (map) {
            containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.get(xid);
            if (containerTransactionContext == null) {
                Transaction transaction = this.importer.importXid(xid, txTimeoutMillis);
                containerTransactionContext = new ContainerTransactionContext(this.transactionManager, transaction);
                this.importedTransactions.put(xid, containerTransactionContext);
            } else if (containerTransactionContext.isThreadAssociated()) {
                throw new ImportedTransactionActiveException(xid);
            }
            containerTransactionContext.resume();
        }
        TransactionContext.setContext(containerTransactionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid) throws XAException, SystemException {
        TransactionContext.setContext(null);
        Map map = this.importedTransactions;
        synchronized (map) {
            ContainerTransactionContext containerTransactionContext = (ContainerTransactionContext)this.importedTransactions.get(xid);
            if (containerTransactionContext == null) {
                throw new XAException("No imported transaction for xid: " + xid);
            }
            if (!containerTransactionContext.isThreadAssociated()) {
                throw new XAException("tx not active for containerTransactionContext: " + containerTransactionContext + ", xid: " + xid);
            }
            containerTransactionContext.suspend();
        }
    }

    public static GBeanInfo getGBeanInfo() {
        return GBEAN_INFO;
    }

    static {
        $assertionsDisabled = !TransactionContextManager.class.desiredAssertionStatus();
        GBeanInfoBuilder infoFactory = new GBeanInfoBuilder(TransactionContextManager.class);
        infoFactory.addOperation("getTransactionManager");
        infoFactory.addOperation("getContext");
        infoFactory.addOperation("setContext", new Class[]{TransactionContext.class});
        infoFactory.addOperation("newContainerTransactionContext");
        infoFactory.addOperation("newBeanTransactionContext", new Class[]{Long.TYPE});
        infoFactory.addOperation("newUnspecifiedTransactionContext");
        infoFactory.addOperation("getStatus");
        infoFactory.addOperation("setRollbackOnly");
        infoFactory.addReference("TransactionManager", ExtendedTransactionManager.class);
        infoFactory.addReference("XidImporter", XidImporter.class);
        infoFactory.addReference("Recovery", Recovery.class);
        infoFactory.addInterface(XATerminator.class);
        infoFactory.addInterface(XAWork.class);
        infoFactory.setConstructor(new String[]{"TransactionManager", "XidImporter", "Recovery"});
        GBEAN_INFO = infoFactory.getBeanInfo();
    }
}

