/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.transaction.manager;

import java.util.Timer;
import java.util.TimerTask;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.apache.geronimo.transaction.ExtendedTransactionManager;
import org.apache.geronimo.transaction.log.UnrecoverableLog;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionLog;
import org.apache.geronimo.transaction.manager.XidFactory;
import org.apache.geronimo.transaction.manager.XidFactoryImpl;
import org.apache.geronimo.transaction.manager.XidImporter;

public class TransactionManagerImpl
implements ExtendedTransactionManager,
XidImporter {
    private final TransactionLog txnLog;
    private final XidFactory xidFactory;
    private final int defaultTransactionTimeoutMilliseconds;
    private final ThreadLocal transactionTimeoutMilliseconds = new ThreadLocal();
    private final ThreadLocal threadTx = new ThreadLocal();
    private final Timer timeoutTimer = new Timer(true);

    public TransactionManagerImpl() {
        this.defaultTransactionTimeoutMilliseconds = 10000;
        this.txnLog = new UnrecoverableLog();
        this.xidFactory = new XidFactoryImpl();
    }

    public TransactionManagerImpl(int defaultTransactionTimeoutSeconds, TransactionLog txnLog, XidFactory xidFactory) {
        if (defaultTransactionTimeoutSeconds <= 0) {
            throw new IllegalArgumentException("defaultTransactionTimeoutSeconds must be positive: attempted value: " + defaultTransactionTimeoutSeconds);
        }
        this.defaultTransactionTimeoutMilliseconds = defaultTransactionTimeoutSeconds * 1000;
        this.txnLog = txnLog;
        this.xidFactory = xidFactory;
    }

    public Transaction getTransaction() throws SystemException {
        return (Transaction)this.threadTx.get();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        if (seconds < 0) {
            throw new SystemException("transaction timeout must be positive or 0 to reset to default");
        }
        if (seconds == 0) {
            this.transactionTimeoutMilliseconds.set(null);
        } else {
            this.transactionTimeoutMilliseconds.set(new Long(seconds * 1000));
        }
    }

    public int getStatus() throws SystemException {
        Transaction tx = this.getTransaction();
        return tx != null ? tx.getStatus() : 6;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.begin(this.getTransactionTimeoutMilliseconds(0L));
    }

    public Transaction begin(long transactionTimeoutMilliseconds) throws NotSupportedException, SystemException {
        if (this.getStatus() != 6) {
            throw new NotSupportedException("Nested Transactions are not supported");
        }
        TransactionImpl tx = new TransactionImpl(this.xidFactory, this.txnLog);
        this.timeoutTimer.schedule((TimerTask)tx, this.getTransactionTimeoutMilliseconds(transactionTimeoutMilliseconds));
        this.threadTx.set(tx);
        tx.setCurrentThread(Thread.currentThread());
        return tx;
    }

    public Transaction suspend() throws SystemException {
        Transaction tx = this.getTransaction();
        if (tx != null) {
            ((TransactionImpl)tx).setCurrentThread(null);
        }
        this.threadTx.set(null);
        return tx;
    }

    public void resume(Transaction tx) throws IllegalStateException, InvalidTransactionException, SystemException {
        if (this.threadTx.get() != null) {
            throw new IllegalStateException("Transaction already associated with current thread");
        }
        if (!(tx instanceof TransactionImpl)) {
            throw new InvalidTransactionException("Cannot resume foreign transaction: " + tx);
        }
        this.threadTx.set(tx);
        ((TransactionImpl)tx).setCurrentThread(Thread.currentThread());
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        tx.setRollbackOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        try {
            tx.commit();
            Object var3_2 = null;
            this.threadTx.set(null);
            ((TransactionImpl)tx).setCurrentThread(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.threadTx.set(null);
            ((TransactionImpl)tx).setCurrentThread(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        Transaction tx = this.getTransaction();
        if (tx == null) {
            throw new IllegalStateException("No transaction associated with current thread");
        }
        try {
            tx.rollback();
            Object var3_2 = null;
            this.threadTx.set(null);
            ((TransactionImpl)tx).setCurrentThread(null);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.threadTx.set(null);
            ((TransactionImpl)tx).setCurrentThread(null);
            throw throwable;
        }
    }

    public Transaction importXid(Xid xid, long transactionTimeoutMilliseconds) throws XAException, SystemException {
        if (transactionTimeoutMilliseconds < 0L) {
            throw new SystemException("transaction timeout must be positive or 0 to reset to default");
        }
        TransactionImpl tx = new TransactionImpl(xid, this.xidFactory, this.txnLog);
        this.timeoutTimer.schedule((TimerTask)tx, this.getTransactionTimeoutMilliseconds(transactionTimeoutMilliseconds));
        return tx;
    }

    public void commit(Transaction tx, boolean onePhase) throws XAException {
        if (onePhase) {
            try {
                tx.commit();
            }
            catch (HeuristicMixedException e) {
                throw (XAException)new XAException().initCause(e);
            }
            catch (HeuristicRollbackException e) {
                throw (XAException)new XAException().initCause(e);
            }
            catch (RollbackException e) {
                throw (XAException)new XAException().initCause(e);
            }
            catch (SecurityException e) {
                throw (XAException)new XAException().initCause(e);
            }
            catch (SystemException e) {
                throw (XAException)new XAException().initCause(e);
            }
        }
        try {
            ((TransactionImpl)tx).preparedCommit();
        }
        catch (SystemException e) {
            throw (XAException)new XAException().initCause(e);
        }
    }

    public void forget(Transaction tx) throws XAException {
    }

    public int prepare(Transaction tx) throws XAException {
        try {
            return ((TransactionImpl)tx).prepare();
        }
        catch (SystemException e) {
            throw (XAException)new XAException().initCause(e);
        }
        catch (RollbackException e) {
            throw (XAException)new XAException().initCause(e);
        }
    }

    public void rollback(Transaction tx) throws XAException {
        try {
            tx.rollback();
        }
        catch (IllegalStateException e) {
            throw (XAException)new XAException().initCause(e);
        }
        catch (SystemException e) {
            throw (XAException)new XAException().initCause(e);
        }
    }

    private long getTransactionTimeoutMilliseconds(long transactionTimeoutMilliseconds) {
        if (transactionTimeoutMilliseconds != 0L) {
            return transactionTimeoutMilliseconds;
        }
        Long timeout = (Long)this.transactionTimeoutMilliseconds.get();
        if (timeout != null) {
            return timeout;
        }
        return this.defaultTransactionTimeoutMilliseconds;
    }
}

