/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.tools.xmlbeans;

import com.bea.x2002.x09.xbean.config.ConfigDocument;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.internal.xmlbeans.wsdlsubst.DefinitionsDocument;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.common.XmlErrorWatcher;
import org.apache.xmlbeans.impl.schema.PathResourceLoader;
import org.apache.xmlbeans.impl.schema.ResourceLoader;
import org.apache.xmlbeans.impl.schema.SchemaTypeLoaderImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemCompiler;
import org.apache.xmlbeans.impl.schema.StscState;
import org.apache.xmlbeans.impl.tool.CodeGenUtil;
import org.apache.xmlbeans.impl.tool.Extension;
import org.apache.xmlbeans.impl.tool.SchemaCodeGenerator;
import org.apache.xmlbeans.impl.tool.SchemaCompilerExtension;
import org.w3.x2001.xmlSchema.SchemaDocument;
import org.xml.sax.EntityResolver;

public class SchemaCompiler {
    private static SchemaTypeSystem loadTypeSystem(String name, File[] xsdFiles, File[] wsdlFiles, File[] configFiles, ResourceLoader cpResourceLoader, boolean download, boolean noUpa, boolean noPvr, Set mdefNamespaces, File baseDir, Map sourcesToCopyMap, Collection outerErrorListener, EntityResolver entityResolver) {
        XmlOptions options;
        int i;
        XmlErrorWatcher errorListener = new XmlErrorWatcher(outerErrorListener);
        SchemaTypeLoader loader = XmlBeans.typeLoaderForClassLoader((ClassLoader)SchemaDocument.class.getClassLoader());
        ArrayList<SchemaDocument.Schema> scontentlist = new ArrayList<SchemaDocument.Schema>();
        if (xsdFiles != null) {
            for (i = 0; i < xsdFiles.length; ++i) {
                try {
                    options = new XmlOptions();
                    options.setLoadLineNumbers();
                    options.setLoadMessageDigest();
                    options.setEntityResolver(entityResolver);
                    XmlObject schemadoc = loader.parse(xsdFiles[i], null, options);
                    if (!(schemadoc instanceof SchemaDocument)) {
                        StscState.addError((Collection)errorListener, (String)("Document " + xsdFiles[i] + " is not a schema file"), (int)1, (XmlObject)schemadoc);
                        continue;
                    }
                    StscState.addInfo((Collection)errorListener, (String)("Loading schema file " + xsdFiles[i]));
                    XmlOptions opts = new XmlOptions().setErrorListener((Collection)errorListener);
                    if (!schemadoc.validate(opts)) continue;
                    scontentlist.add(((SchemaDocument)schemadoc).getSchema());
                    continue;
                }
                catch (XmlException e) {
                    errorListener.add((Object)e.getError());
                    continue;
                }
                catch (Exception e) {
                    StscState.addError((Collection)errorListener, (String)("Cannot load file " + xsdFiles[i] + ": " + e), (int)1, (File)xsdFiles[i]);
                }
            }
        }
        if (wsdlFiles != null) {
            for (i = 0; i < wsdlFiles.length; ++i) {
                try {
                    options = new XmlOptions();
                    options.setLoadLineNumbers();
                    options.setEntityResolver(entityResolver);
                    options.setLoadSubstituteNamespaces(Collections.singletonMap("http://schemas.xmlsoap.org/wsdl/", "http://www.apache.org/internal/xmlbeans/wsdlsubst"));
                    XmlObject wsdldoc = loader.parse(wsdlFiles[i], null, options);
                    if (!(wsdldoc instanceof DefinitionsDocument)) {
                        StscState.addError((Collection)errorListener, (String)("Document " + wsdlFiles[i] + " is not a wsdl file"), (int)1, (XmlObject)wsdldoc);
                        continue;
                    }
                    if (SchemaCompiler.wsdlContainsEncoded(wsdldoc)) {
                        StscState.addWarning((Collection)errorListener, (String)("The WSDL " + wsdlFiles[i] + " uses SOAP encoding. SOAP encoding is not compatible with literal XML Schema."), (int)1, (XmlObject)wsdldoc);
                    }
                    StscState.addInfo((Collection)errorListener, (String)("Loading wsdl file " + wsdlFiles[i]));
                    XmlObject[] types = ((DefinitionsDocument)wsdldoc).getDefinitions().getTypesArray();
                    int count = 0;
                    for (int j = 0; j < types.length; ++j) {
                        SchemaDocument.Schema[] schemas = (SchemaDocument.Schema[])types[j].selectPath("declare namespace xs=\"http://www.w3.org/2001/XMLSchema\" xs:schema");
                        for (int k = 0; k < schemas.length; ++k) {
                            if (!schemas[k].validate(new XmlOptions().setErrorListener((Collection)errorListener))) continue;
                            scontentlist.add(schemas[k]);
                        }
                        count += schemas.length;
                    }
                    StscState.addInfo((Collection)errorListener, (String)("Processing " + count + " schema(s) in " + wsdlFiles[i].toString()));
                    continue;
                }
                catch (XmlException e) {
                    errorListener.add((Object)e.getError());
                    continue;
                }
                catch (Exception e) {
                    StscState.addError((Collection)errorListener, (String)("Cannot load file " + wsdlFiles[i] + ": " + e), (int)1, (File)wsdlFiles[i]);
                }
            }
        }
        SchemaDocument.Schema[] sdocs = scontentlist.toArray(new SchemaDocument.Schema[scontentlist.size()]);
        ArrayList<ConfigDocument.Config> cdoclist = new ArrayList<ConfigDocument.Config>();
        if (configFiles != null) {
            for (int i2 = 0; i2 < configFiles.length; ++i2) {
                try {
                    XmlOptions options2 = new XmlOptions();
                    options2.put((Object)"LOAD_LINE_NUMBERS");
                    options2.setEntityResolver(entityResolver);
                    XmlObject configdoc = loader.parse(configFiles[i2], null, options2);
                    if (!(configdoc instanceof ConfigDocument)) {
                        StscState.addError((Collection)errorListener, (String)("Document " + configFiles[i2] + " is not an xsd config file"), (int)1, (XmlObject)configdoc);
                        continue;
                    }
                    StscState.addInfo((Collection)errorListener, (String)("Loading config file " + configFiles[i2]));
                    if (!configdoc.validate(new XmlOptions().setErrorListener((Collection)errorListener))) continue;
                    cdoclist.add(((ConfigDocument)configdoc).getConfig());
                    continue;
                }
                catch (XmlException e) {
                    errorListener.add((Object)e.getError());
                    continue;
                }
                catch (Exception e) {
                    StscState.addError((Collection)errorListener, (String)("Cannot load xsd config file " + configFiles[i2] + ": " + e), (int)2, (File)configFiles[i2]);
                }
            }
        }
        ConfigDocument.Config[] cdocs = cdoclist.toArray(new ConfigDocument.Config[cdoclist.size()]);
        SchemaTypeLoader linkTo = SchemaTypeLoaderImpl.build(null, (ResourceLoader)cpResourceLoader, null);
        URI baseURI = null;
        if (baseDir != null) {
            baseURI = baseDir.toURI();
        }
        XmlOptions opts = new XmlOptions();
        if (download) {
            opts.setCompileDownloadUrls();
        }
        if (noUpa) {
            opts.setCompileNoUpaRule();
        }
        if (noPvr) {
            opts.setCompileNoPvrRule();
        }
        if (mdefNamespaces != null) {
            opts.setCompileMdefNamespaces(mdefNamespaces);
        }
        opts.setCompileNoValidation();
        opts.setEntityResolver(entityResolver);
        SchemaTypeSystemCompiler.Parameters params = new SchemaTypeSystemCompiler.Parameters();
        params.setName(name);
        params.setSchemas(sdocs);
        params.setConfigs(cdocs);
        params.setLinkTo(linkTo);
        params.setOptions(opts);
        params.setErrorListener((Collection)errorListener);
        params.setJavaize(true);
        params.setBaseURI(baseURI);
        params.setSourcesToCopyMap(sourcesToCopyMap);
        return SchemaTypeSystemCompiler.compile((SchemaTypeSystemCompiler.Parameters)params);
    }

    public static boolean compile(Parameters params) {
        File baseDir = params.getBaseDir();
        File[] xsdFiles = params.getXsdFiles();
        File[] wsdlFiles = params.getWsdlFiles();
        File[] javaFiles = params.getJavaFiles();
        File[] configFiles = params.getConfigFiles();
        File[] classpath = params.getClasspath();
        File outputJar = params.getOutputJar();
        String name = params.getName();
        File srcDir = params.getSrcDir();
        File classesDir = params.getClassesDir();
        String compiler = params.getCompiler();
        String jar = params.getJar();
        String memoryInitialSize = params.getMemoryInitialSize();
        String memoryMaximumSize = params.getMemoryMaximumSize();
        boolean nojavac = params.isNojavac();
        boolean debug = params.isDebug();
        boolean verbose = params.isVerbose();
        boolean quiet = params.isQuiet();
        boolean download = params.isDownload();
        boolean noUpa = params.isNoUpa();
        boolean noPvr = params.isNoPvr();
        Collection outerErrorListener = params.getErrorListener();
        String repackage = params.getRepackage();
        List extensions = params.getExtensions();
        boolean jaxb = params.getJaxb();
        Set mdefNamespaces = params.getMdefNamespaces();
        EntityResolver entityResolver = params.getEntityResolver();
        if (srcDir == null || classesDir == null) {
            throw new IllegalArgumentException("src and class gen directories may not be null.");
        }
        long start = System.currentTimeMillis();
        if (baseDir == null) {
            baseDir = new File(System.getProperty("user.dir"));
        }
        PathResourceLoader cpResourceLoader = null;
        HashMap sourcesToCopyMap = new HashMap();
        if (classpath != null) {
            cpResourceLoader = new PathResourceLoader(classpath);
        }
        boolean result = true;
        XmlErrorWatcher errorListener = new XmlErrorWatcher(outerErrorListener);
        SchemaTypeSystem system = SchemaCompiler.loadTypeSystem(name, xsdFiles, wsdlFiles, configFiles, (ResourceLoader)cpResourceLoader, download, noUpa, noPvr, mdefNamespaces, baseDir, sourcesToCopyMap, (Collection)errorListener, entityResolver);
        if (errorListener.hasError()) {
            result = false;
        }
        long finish = System.currentTimeMillis();
        if (!quiet) {
            System.out.println("Time to build schema type system: " + (double)(finish - start) / 1000.0 + " seconds");
        }
        if (result && system != null) {
            start = System.currentTimeMillis();
            ArrayList<File> sourcefiles = new ArrayList<File>();
            result &= SchemaCodeGenerator.compileTypeSystem((SchemaTypeSystem)system, (File)srcDir, (File[])javaFiles, sourcesToCopyMap, (File[])classpath, (File)classesDir, (File)outputJar, (boolean)nojavac, (boolean)jaxb, (XmlErrorWatcher)errorListener, (String)repackage, (boolean)verbose, sourcefiles);
            if (result &= !errorListener.hasError()) {
                finish = System.currentTimeMillis();
                if (!quiet) {
                    System.out.println("Time to generate code: " + (double)(finish - start) / 1000.0 + " seconds");
                }
            }
            if (result && !nojavac) {
                start = System.currentTimeMillis();
                if (javaFiles != null) {
                    sourcefiles.addAll(Arrays.asList(javaFiles));
                }
                if (!CodeGenUtil.externalCompile(sourcefiles, (File)classesDir, (File[])classpath, (boolean)debug, (String)compiler, (String)memoryInitialSize, (String)memoryMaximumSize, (boolean)quiet, (boolean)verbose)) {
                    result = false;
                }
                finish = System.currentTimeMillis();
                if (result && !params.isQuiet()) {
                    System.out.println("Time to compile code: " + (double)(finish - start) / 1000.0 + " seconds");
                }
                if (result && outputJar != null) {
                    if (!CodeGenUtil.externalJar((File)classesDir, (File)outputJar, (String)jar, (boolean)quiet, (boolean)verbose)) {
                        result = false;
                    }
                    if (result && !params.isQuiet()) {
                        System.out.println("Compiled types to: " + outputJar);
                    }
                }
            }
        }
        if (!result && !quiet) {
            System.out.println("BUILD FAILED");
        } else {
            SchemaCompiler.runExtensions(extensions, system, classesDir);
        }
        if (cpResourceLoader != null) {
            cpResourceLoader.close();
        }
        return result;
    }

    private static void runExtensions(List extensions, SchemaTypeSystem system, File classesDir) {
        if (extensions != null && extensions.size() > 0) {
            SchemaCompilerExtension sce = null;
            Iterator i = extensions.iterator();
            HashMap<String, String> extensionParms = null;
            String classesDirName = null;
            try {
                classesDirName = classesDir.getCanonicalPath();
            }
            catch (IOException e) {
                System.out.println("WARNING: Unable to get the path for schema jar file");
                classesDirName = classesDir.getAbsolutePath();
            }
            while (i.hasNext()) {
                Extension extension = (Extension)i.next();
                try {
                    sce = (SchemaCompilerExtension)extension.getClassName().newInstance();
                }
                catch (InstantiationException e) {
                    System.out.println("UNABLE to instantiate schema compiler extension:" + extension.getClassName().getName());
                    System.out.println("EXTENSION Class was not run");
                    break;
                }
                catch (IllegalAccessException e) {
                    System.out.println("ILLEGAL ACCESS Exception when attempting to instantiate schema compiler extension: " + extension.getClassName().getName());
                    System.out.println("EXTENSION Class was not run");
                    break;
                }
                System.out.println("Running Extension: " + sce.getExtensionName());
                extensionParms = new HashMap<String, String>();
                Iterator parmsi = extension.getParams().iterator();
                while (parmsi.hasNext()) {
                    Extension.Param p = (Extension.Param)parmsi.next();
                    extensionParms.put(p.getName(), p.getValue());
                }
                extensionParms.put("classesDir", classesDirName);
                sce.schemaCompilerExtension(system, extensionParms);
            }
        }
    }

    private static boolean wsdlContainsEncoded(XmlObject wsdldoc) {
        XmlObject[] useAttrs = wsdldoc.selectPath("declare namespace soap='http://schemas.xmlsoap.org/wsdl/soap/' .//soap:body/@use|.//soap:header/@use|.//soap:fault/@use");
        for (int i = 0; i < useAttrs.length; ++i) {
            if (!"encoded".equals(((SimpleValue)useAttrs[i]).getStringValue())) continue;
            return true;
        }
        return false;
    }

    public static class Parameters {
        private File baseDir;
        private File[] xsdFiles;
        private File[] wsdlFiles;
        private File[] javaFiles;
        private File[] configFiles;
        private File[] classpath;
        private File outputJar;
        private String name;
        private File srcDir;
        private File classesDir;
        private String memoryInitialSize;
        private String memoryMaximumSize;
        private String compiler;
        private String jar;
        private boolean nojavac;
        private boolean quiet;
        private boolean verbose;
        private boolean download;
        private Collection errorListener;
        private boolean noUpa;
        private boolean noPvr;
        private boolean debug;
        private String repackage;
        private List extensions = Collections.EMPTY_LIST;
        private boolean jaxb;
        private Set mdefNamespaces = Collections.EMPTY_SET;
        private EntityResolver entityResolver;

        public File getBaseDir() {
            return this.baseDir;
        }

        public void setBaseDir(File baseDir) {
            this.baseDir = baseDir;
        }

        public File[] getXsdFiles() {
            return this.xsdFiles;
        }

        public void setXsdFiles(File[] xsdFiles) {
            this.xsdFiles = xsdFiles;
        }

        public File[] getWsdlFiles() {
            return this.wsdlFiles;
        }

        public void setWsdlFiles(File[] wsdlFiles) {
            this.wsdlFiles = wsdlFiles;
        }

        public File[] getJavaFiles() {
            return this.javaFiles;
        }

        public void setJavaFiles(File[] javaFiles) {
            this.javaFiles = javaFiles;
        }

        public File[] getConfigFiles() {
            return this.configFiles;
        }

        public void setConfigFiles(File[] configFiles) {
            this.configFiles = configFiles;
        }

        public File[] getClasspath() {
            return this.classpath;
        }

        public void setClasspath(File[] classpath) {
            this.classpath = classpath;
        }

        public File getOutputJar() {
            return this.outputJar;
        }

        public void setOutputJar(File outputJar) {
            this.outputJar = outputJar;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public File getSrcDir() {
            return this.srcDir;
        }

        public void setSrcDir(File srcDir) {
            this.srcDir = srcDir;
        }

        public File getClassesDir() {
            return this.classesDir;
        }

        public void setClassesDir(File classesDir) {
            this.classesDir = classesDir;
        }

        public boolean isNojavac() {
            return this.nojavac;
        }

        public void setNojavac(boolean nojavac) {
            this.nojavac = nojavac;
        }

        public boolean isQuiet() {
            return this.quiet;
        }

        public void setQuiet(boolean quiet) {
            this.quiet = quiet;
        }

        public boolean isVerbose() {
            return this.verbose;
        }

        public void setVerbose(boolean verbose) {
            this.verbose = verbose;
        }

        public boolean isDownload() {
            return this.download;
        }

        public void setDownload(boolean download) {
            this.download = download;
        }

        public boolean isNoUpa() {
            return this.noUpa;
        }

        public void setNoUpa(boolean noUpa) {
            this.noUpa = noUpa;
        }

        public boolean isNoPvr() {
            return this.noPvr;
        }

        public void setNoPvr(boolean noPvr) {
            this.noPvr = noPvr;
        }

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public String getMemoryInitialSize() {
            return this.memoryInitialSize;
        }

        public void setMemoryInitialSize(String memoryInitialSize) {
            this.memoryInitialSize = memoryInitialSize;
        }

        public String getMemoryMaximumSize() {
            return this.memoryMaximumSize;
        }

        public void setMemoryMaximumSize(String memoryMaximumSize) {
            this.memoryMaximumSize = memoryMaximumSize;
        }

        public String getCompiler() {
            return this.compiler;
        }

        public void setCompiler(String compiler) {
            this.compiler = compiler;
        }

        public String getJar() {
            return this.jar;
        }

        public void setJar(String jar) {
            this.jar = jar;
        }

        public void setJaxb(boolean jaxb) {
            this.jaxb = jaxb;
        }

        public boolean getJaxb() {
            return this.jaxb;
        }

        public Collection getErrorListener() {
            return this.errorListener;
        }

        public void setErrorListener(Collection errorListener) {
            this.errorListener = errorListener;
        }

        public String getRepackage() {
            return this.repackage;
        }

        public void setRepackage(String newRepackage) {
            this.repackage = newRepackage;
        }

        public List getExtensions() {
            return this.extensions;
        }

        public void setExtensions(List extensions) {
            this.extensions = extensions;
        }

        public Set getMdefNamespaces() {
            return this.mdefNamespaces;
        }

        public void setMdefNamespaces(Set mdefNamespaces) {
            this.mdefNamespaces = mdefNamespaces;
        }

        public EntityResolver getEntityResolver() {
            return this.entityResolver;
        }

        public void setEntityResolver(EntityResolver entityResolver) {
            this.entityResolver = entityResolver;
        }
    }
}

