package gg.gamerewards

import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleEventObserver
import androidx.lifecycle.LifecycleOwner
import gg.gamerewards.interfaces.RichieLifecycleListener


class RichieLifecycleOwner(private val richieLifecycleListener : RichieLifecycleListener? = null) :
    LifecycleEventObserver {

    override fun onStateChanged(source: LifecycleOwner, event: Lifecycle.Event) {
        when(event){
            Lifecycle.Event.ON_START -> richieLifecycleListener?.onForeground()
            Lifecycle.Event.ON_STOP -> richieLifecycleListener?.onBackground()
            Lifecycle.Event.ON_DESTROY -> richieLifecycleListener?.onDestroy()
            else -> {}
        }
    }
}
