package gg.gamerewards.builder

class RichieExtensions private constructor(
    val subId1: String,
    val subId2: String,
    val subId3: String,
    val subId4: String,
    val subId5: String
) {
    class Builder {
        private var subId1: String = ""
        private var subId2: String = ""
        private var subId3: String = ""
        private var subId4: String = ""
        private var subId5: String = ""

        fun setSubId1(subId1: String) = apply { this.subId1 = subId1 }
        fun setSubId2(subId2: String) = apply { this.subId2 = subId2 }
        fun setSubId3(subId3: String) = apply { this.subId3 = subId3 }
        fun setSubId4(subId4: String) = apply { this.subId4 = subId4 }
        fun setSubId5(subId5: String) = apply { this.subId5 = subId5 }

        fun build() = RichieExtensions(
            subId1,
            subId2,
            subId3,
            subId4,
            subId5
        )
    }

    override fun toString(): String {
        return "RichieExtensions subId1 : $subId1, subId2 : $subId1, subId3 : $subId3, subId4 : $subId4, subId5 : $subId5"
    }
}
