package gg.gamerewards.builder

class RichieUserProfile(private val gender : String?,private val birthDay : String?) {

    val userGender: UserGender
        get() {
            return parseGender(gender)
        }

    override fun toString(): String {
        return "RichieUserProfile gender : $gender, birthDay : $birthDay"
    }
}

fun parseGender(gender : String?) : UserGender{
    return when(gender){
        UserGender.MALE.name -> UserGender.MALE
        UserGender.FEMALE.name -> UserGender.FEMALE
        else -> UserGender.NOT_PREFER_TO_SAY
    }
}

enum class UserGender{
    MALE,
    FEMALE,
    NOT_PREFER_TO_SAY
}