package gg.gamerewards.data.api

import gg.gamerewards.data.model.DeviceInfo
import gg.gamerewards.data.model.request.ConsumeClaimRequest
import gg.gamerewards.data.model.request.GuestLoginRequest
import gg.gamerewards.data.model.request.PlayTimeEventsRequest

/**
 * Created by Hasan Güler on 18.05.2023.
 */
internal class ApiRepository(private val apiService: ApiService) {
    suspend fun getPlacementDetailsByPlacementId(placementId: String) = apiService.getPlacementDetailsByPlacementId(placementId)
    suspend fun guestLogin(deviceInfo: DeviceInfo) = apiService.guestLogin(GuestLoginRequest(deviceInfo))
    suspend fun refreshToken(deviceInfo: DeviceInfo) = apiService.refreshToken(GuestLoginRequest(deviceInfo))
    suspend fun getClaimHistory(lastClaim: Long?) = apiService.getClaimHistory(lastClaim)
    suspend fun getOfferDetail(offerKeyId: String,offerGroupTitle : String) = apiService.getOfferDetail(offerKeyId, offerGroupTitle)
    suspend fun sendPlayTimeEvents(playTimeEvents : PlayTimeEventsRequest?) = apiService.sendPlayTimeEvents(playTimeEvents)
    suspend fun getSystemTime() = apiService.getSystemTime()
    suspend fun consumeClaim(id: Int) = apiService.consumeClaim(ConsumeClaimRequest(id))
    suspend fun giveBonusCoinToUserKeyId(userKeyId: String, rewardAmount: Int) = apiService.giveBonusCoinToUserKeyId(userKeyId, rewardAmount)
}