package gg.gamerewards.data.api

import gg.gamerewards.data.local.PrefManager
import gg.gamerewards.di.ApiModule
import okhttp3.HttpUrl.Companion.toHttpUrlOrNull
import okhttp3.Interceptor
import okhttp3.Response


internal class BaseUrlInterceptor(private val prefManager : PrefManager) : Interceptor {

    override fun intercept(chain: Interceptor.Chain): Response {
        val originalRequest = chain.request()
        val originalUrl = originalRequest.url

        val newBaseUrlString = if(prefManager.baseUrl.isNullOrEmpty()) ApiModule.BASE_URL else prefManager.baseUrl!!
        val newBaseUrl = newBaseUrlString.toHttpUrlOrNull()

        // Construct the new URL using the new base URL while preserving the original URL's path and query
        val newUrl = newBaseUrl?.newBuilder()
            ?.apply {
                encodedPath(originalUrl.encodedPath)
                query(originalUrl.query)
            }
            ?.build() ?: originalUrl

        // Build the new request, preserving headers and body
        val newRequest = originalRequest.newBuilder()
            .url(newUrl)
            .headers(originalRequest.headers)
            .method(originalRequest.method, originalRequest.body)
            .build()

        return chain.proceed(newRequest)
    }
}