package gg.gamerewards.data.api

import android.annotation.SuppressLint
import android.text.TextUtils
import gg.gamerewards.di.ApiModule
import gg.gamerewards.utils.Cryptor
import okhttp3.Interceptor
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.Request
import okhttp3.Response
import okhttp3.ResponseBody
import java.io.IOException

/**
 * Created by Hasan Güler on 24.07.2023.
 */
internal class DecryptionInterceptor : Interceptor {
    @SuppressLint("SuspiciousIndentation")
    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        val request: Request = chain.request()
        if (!shouldDecrypt(request)) { //If dont need to encrypt, continue without encryption.
            return chain.proceed(request)
        }
        val response: Response = chain.proceed(chain.request())
        if (response.isSuccessful) {
            val newResponse = response.newBuilder()
            var contentType = response.header("Content-Type")

            if (TextUtils.isEmpty(contentType)) contentType = "application/json"

            var decryptedString: String? = null
            try {
                decryptedString = Cryptor.decrypt(response.body?.string())
            } catch (e: java.lang.Exception) {
                e.printStackTrace()
            }
            newResponse.body(decryptedString?.let {
                ResponseBody.create(contentType?.toMediaTypeOrNull(), it)
            })
            return newResponse.build()
        }
        return response
    }

    companion object {
        fun shouldDecrypt(request: Request): Boolean {
            if (request.url.toString() == ApiModule.APP_CATEGORY_URL) {
                return true
            }
            return false
        }
    }
}