package gg.gamerewards.data.api

import gg.gamerewards.di.ApiModule
import gg.gamerewards.utils.Cryptor
import okhttp3.Interceptor
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.Request
import okhttp3.RequestBody
import okhttp3.Response
import okio.Buffer
import java.io.IOException

/**
 * Created by Hasan Güler on 24.07.2023.
 */
internal class EncryptionInterceptor : Interceptor {
    @Throws(IOException::class)
    override fun intercept(chain: Interceptor.Chain): Response {
        var request: Request = chain.request()

        if (!shouldIntercept(request)) { //If dont need to encrypt, continue without encryption.
            return chain.proceed(request)
        }

        val oldBody: RequestBody? = request.body
        val buffer = Buffer()
        oldBody?.writeTo(buffer)
        val strOldBody: String = buffer.readUtf8()
        val mediaType = "text/plain; charset=utf-8".toMediaTypeOrNull()
        val strNewBody: String = Cryptor.encrypt(strOldBody, isWithV2(request))
        val body= RequestBody.create(mediaType, strNewBody)
        request = request.newBuilder().header("Content-Type", body.contentType().toString())
            .header("Content-Length", body.contentLength().toString())
            .method(request.method, body).build()
        return chain.proceed(request)
    }

    private fun shouldIntercept(request: Request): Boolean {
        if (request.url.toString() == ApiModule.APP_CATEGORY_URL) {
            return true
        }

        if (request.url.toString().contains("encPlaytimeEvent")) {
            return true
        }
        
        if (request.url.toString().contains("encPlaytimeEvents")) {
            return true
        }

        if (request.url.toString().endsWith("v1/encEvent")) {
            return true
        }
        return false
    }

    companion object {
        fun isWithV2(request: Request): Boolean {
            if ((request.url.toString().contains("encPlaytimeEvent"))) {
                return true
            }

            if (request.url.toString().endsWith("v1/encEvent")) {
                return true
            }

            return false
        }
    }
}