package gg.gamerewards.data.api

import android.content.Context
import gg.gamerewards.utils.isInternetConnected
import okhttp3.Interceptor
import okhttp3.Response

/**
 * Created by Hasan Güler on 31.07.2023.
 */
internal class InternetConnectivityInterceptor(private val context: Context) : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response {
        if (!context.isInternetConnected()) {
            throw NoInternetConnectivityException()
        }
        return chain.proceed(chain.request())
    }
}

