package gg.gamerewards.data.api

import android.content.Context
import android.util.Log
import com.google.gson.Gson
import gg.gamerewards.data.model.BaseResponse
import okhttp3.Interceptor
import okhttp3.Response
import java.io.IOException


/**
 * Created by Hasan Güler on 17.07.2023.
 */
internal class ResponseCodeInterceptor(val context: Context) : Interceptor {
    override fun intercept(chain: Interceptor.Chain): Response {
        val request = chain.request()
        val response = chain.proceed(request)
        if (!DecryptionInterceptor.shouldDecrypt(request)) {
            checkCode(null,response.peekBody(Long.MAX_VALUE).string())
        }
        else{
            checkCode(response.code,response.body.toString())
        }
        return response
    }

    /**
     * Checks [code] and Throws an IOException if needed.
     */
    private fun checkCode(responseCode : Int?,responseBody: String) {
        var exception : IOException? = null
        runCatching {
            responseCode?.let {
                exception = when (responseCode) {
                    200 -> null
                    481 -> InactiveCountryException(responseBody)
                    401, 403 -> NotAuthorizedException(responseBody)
                    else -> CommonException(responseBody)
                }
            }?: run {
                val baseResponse = Gson().fromJson(responseBody, BaseResponse::class.java)
                baseResponse?.code?.let { code ->
                    exception = when (code) {
                        200 -> null
                        481 -> InactiveCountryException(baseResponse.message)
                        401, 403 -> NotAuthorizedException(baseResponse.message)
                        else -> CommonException(baseResponse.message)
                    }
                }
            }
        }.onFailure {
            Log.d("Richie", "Failure : ${it.message}")
            exception = CommonException(null)
        }
        exception?.let { throw it }
    }
}