package gg.gamerewards.data.local

import android.content.Context
import android.content.SharedPreferences
import javax.inject.Inject

internal class PrefManager @Inject constructor(context: Context) {

    fun clearPreferencesIfNeeded(context: Context) {
        kotlin.runCatching {
            val preferences = context.getSharedPreferences("AdSdkPreferences", Context.MODE_PRIVATE)
            val installTime = context.packageManager.getPackageInfo(context.packageName, 0).firstInstallTime
            val lastClearTime = preferences.getLong(LAST_CLEAR_TIME, 0)
            if (lastClearTime < installTime) {
                preferences.edit().clear().apply()
                preferences.edit().putLong(LAST_CLEAR_TIME, System.currentTimeMillis()).apply()
            }
        }
    }

    private val preferences: SharedPreferences = context.getSharedPreferences("RichieOfferwallPreferences", Context.MODE_PRIVATE)

    private companion object {
        const val LAST_CLEAR_TIME = "LAST_CLEAR_TIME"
        private const val BASE_URL: String = "BASE_URL"
        private const val JWT_TOKEN: String = "JWT_TOKEN"
        private const val IS_VPN_DISABLED: String = "IS_VPN_DISABLED"
        private const val LAST_PLAYTIME_CLAIM: String = "LAST_PLAYTIME_CLAIM"
        private const val LAST_CLAIM_HISTORY_CHECK: String = "LAST_CLAIM_HISTORY_CHECK"
        private const val PLACEMENT_ID: String = "PLACEMENT_ID"
    }

    val hasJwtToken: Boolean
        get() = jwtToken.isNotEmpty()

    var placementId: String
        get() = preferences.getString(PLACEMENT_ID, "") ?: ""
        set(value) {
            preferences.edit().putString(PLACEMENT_ID, value).apply()
        }

    var baseUrl: String?
        get() = preferences.getString(BASE_URL, null)
        set(value) {
            preferences.edit().putString(BASE_URL, value).apply()
        }

    var jwtToken: String
        get() = preferences.getString(JWT_TOKEN, "") ?: ""
        set(value) {
            preferences.edit().putString(JWT_TOKEN, value).apply()
        }

    var isVpnDisabled: Boolean
        get() = preferences.getBoolean(IS_VPN_DISABLED, false)
        set(value) {
            preferences.edit().putBoolean(IS_VPN_DISABLED, value).apply()
        }
    var lastPlaytimeClaim: Long
        get() = preferences.getLong(LAST_PLAYTIME_CLAIM, -1L)
        set(value) {
            preferences.edit().putLong(LAST_PLAYTIME_CLAIM, value).apply()
        }
    var lastClaimHistoryCheck: Long
        get() = preferences.getLong(LAST_CLAIM_HISTORY_CHECK,-1)
        set(value) {
            preferences.edit().putLong(LAST_CLAIM_HISTORY_CHECK, value).apply()
        }

}