package gg.gamerewards.data.model

import android.annotation.SuppressLint
import android.content.Context
import android.os.Build
import com.google.gson.annotations.SerializedName
import gg.gamerewards.utils.RichieUtils
import java.util.Locale

/**
 * Created by Hasan Güler on 31.07.2023.
 */
internal data class DeviceInfo(
    @SuppressLint("HardwareIds")
    @SerializedName("deviceHwId") val deviceHwId: String,
    @SerializedName("deviceType") val deviceType: String,
    @SerializedName("appVersion") val appVersion: String = "10000",
    @SerializedName("appBuildNumber") val appBuildNumber: String = "10001",
    @SerializedName("languageCode") val languageCode: String = Locale.getDefault().language,
    @SerializedName("countryCode") val countryCode: String = Locale.getDefault().country,
    @SerializedName("osType") val osType: String = "Android",
    @SerializedName("osVersion") val osVersion: String = Build.VERSION.SDK_INT.toString(),
    @SerializedName("manufacturer") val manufacturer: String = Build.MANUFACTURER,
    @SerializedName("brand") val brand: String = Build.BRAND,
    @SerializedName("model") val model: String = Build.MODEL,
    @SerializedName("userAgent") var userAgent: String?,
    @SerializedName("isPhysicalDevice") val isPhysicalDevice: Boolean = !RichieUtils.isEmulator(),
) {
    companion object {
        @SuppressLint("HardwareIds")
        fun create(context: Context): DeviceInfo = DeviceInfo(
            RichieUtils.getDeviceId(context),
            if (RichieUtils.isTablet(context)) "Tablet" else "Phone",
            userAgent = System.getProperty("http.agent")
        )
    }
}