package gg.gamerewards.data.model.response

import android.os.Parcelable
import com.google.gson.annotations.SerializedName
import gg.gamerewards.data.model.BaseResponse
import kotlinx.parcelize.Parcelize

/**
 * Created by Hasan Güler on 1.06.2023.
 */
internal data class OfferDetailResponse(
    @SerializedName("data") val gameDetailData: GameDetail?,
) : BaseResponse()

@Parcelize
internal data class GameDetail(
    @SerializedName("title") val title: String?,
    @SerializedName("subTitle") val subTitle: String?,
    @SerializedName("description") val description: String?,
    @SerializedName("bundleID") val bundleID: String?,
    @SerializedName("cardIconImageUrl") val cardIconImageUrl: String?,
    @SerializedName("offerDetailButtonLabel") val offerDetailButtonLabel: String?,
    @SerializedName("mediaUrl") val mediaUrl: String?,
    @SerializedName("checkpoints") val checkpoints: ArrayList<CheckPoint>?,
    @SerializedName("videoUrl") val videoUrl: String?,
    @SerializedName("clickUrl") val clickUrl: String?,
    @SerializedName("offerSource") val offerSource: String?,
    @SerializedName("action") val action: String?,
    @SerializedName("clickId") val clickId: String?,
    @SerializedName("isPlaytimeHandledByOffer") val isPlaytimeHandledByOffer: Boolean?,
    @SerializedName("impressionURL") val impressionURL: String?
    ): Parcelable

@Parcelize
data class CheckPoint(
    @SerializedName("checkpointId") val checkpointId: String?,
    @SerializedName("eventType") val eventType: String?,
    @SerializedName("name") val name: String?,
    @SerializedName("title") val title: String?,
    @SerializedName("subTitle") val subtitle: String?,
    @SerializedName("description") val description: String?,
    @SerializedName("iconUrl") val iconUrl: String?,
    @SerializedName("type") val type: String?,
    @SerializedName("targetValue") val targetValue: Double?,
    @SerializedName("currentValue") val currentValue: Double?,
    @SerializedName("coinRewardAmount") val coinRewardAmount: Long?,
    @SerializedName("coinUpToAmount") val coinUpToAmount: Long?,
    @SerializedName("isBlocked") val isBlocked: Boolean?,
    @SerializedName("blockedReasonText") val blockedReasonText: String?,
    @SerializedName("blockageType") val blockageType: String?,
    @SerializedName("isCountBased") val isCountBased: Boolean?,
    @SerializedName("currentCount") val currentCount: Double?,
    @SerializedName("targetCount") val targetCount: Double?,
) : Parcelable {

    val viewProgress: Int
    get() {
        return try {
            if (isCountBased != true)
                (100 * ((currentValue ?: 0.0) / (targetValue ?: 1.0))).toInt()
            else
               if (targetCount != -1.0) (100 * ((currentCount ?: 0.0) / (targetCount ?: 1.0))).toInt() else 0
        } catch (_: Exception) {
            0
        }
    }

    val checkpointType : CheckpointViewType
        get() {
            return if(eventType == "play_time") CheckpointViewType.TIME_BASED else CheckpointViewType.LEVEL
        }

    val isCompleted: Boolean
        get() {
            return if (isCountBased != true) {
                if (targetValue != null && targetValue != 0.0) {
                    targetValue <= (currentValue ?: 0.0)
                } else
                    false
            } else {
                if (targetCount != null && targetCount > 0.0) {
                    targetCount <= (currentCount ?: 0.0)
                } else
                    false
            }
        }

}



enum class CheckpointViewType{
    LEVEL,
    TIME_BASED;

    val order: Int
        get() {
            return CheckpointViewType.values().indexOf(this)
        }
}
