package gg.gamerewards.data.model.response

import com.google.gson.annotations.SerializedName
import gg.gamerewards.data.model.BaseResponse
import gg.gamerewards.data.model.Profile
import kotlin.math.ceil
import kotlin.math.roundToInt

/**
 * Created by Hasan Güler on 18.05.2023.
 */
internal data class PlacementResponse(@SerializedName("data") val placement: Placement?) : BaseResponse()

internal data class Placement(
    @SerializedName("headerImageUrl") val headerImageUrl: String?,
    @SerializedName("offerGroups") var offerGroups: ArrayList<OfferGroup>?
)

internal data class OfferGroup(
    @SerializedName("viewStyle") val viewStyle: GamesFragmentOfferType?,
    @SerializedName("groupTitle") val groupTitle: String?,
    @SerializedName("offers") var offers: ArrayList<Offer>?,
    @SerializedName("showTitle") val showTitle: Boolean?,
    @SerializedName("isActive") var isActive: Boolean?
)

internal data class Offer(
    @SerializedName("bundleID") val bundleID: String?,
    @SerializedName("title") val title: String?,
    @SerializedName("subTitle") val subtitle: String?,
    @SerializedName("clickUrl") var clickUrl: String?,
    @SerializedName("description") val description: String?,
    @SerializedName("action") val action: String?,
    @SerializedName("horizontalCardImageUrl") val horizontalCardImageUrl: String?,
    @SerializedName("verticalCardImageUrl") val verticalCardImageUrl: String?,
    @SerializedName("actionButtonTitle") val actionButtonTitle: String?,
    @SerializedName("targetValueOfClosestToFinishCheckpoint") val targetValueOfClosestToFinishCheckpoint: Double?,
    @SerializedName("currentValueOfClosestToFinishCheckpoint") val currentValueOfClosestToFinishCheckpoint: Double?,
    @SerializedName("cardBackgroundColor") val cardBackgroundColor: String?,
    @SerializedName("actionButtonBackgroundColor") val actionButtonBackgroundColor: String?,
    @SerializedName("actionButtonTextColor") val actionButtonTextColor: String?,
    @SerializedName("cardIconImageUrl") val cardIconImageUrl: String?,
    @SerializedName("titleTextColor") val titleTextColor: String?,
    @SerializedName("cardLabel") val cardLabel: String?,
    @SerializedName("cardLabelTextColor") val cardLabelTextColor: String?,
    @SerializedName("cardLabelBackgroundColor") val cardLabelBackgroundColor: String?,
    @SerializedName("cardLabelIconUrl") val cardLabelIconUrl: String?,
    @SerializedName("isPremiumOffer") val isPremiumOffer: Boolean?,
    @SerializedName("premiumUnlockCoinAmount") val premiumUnlockCoinAmount: Long?,
    @SerializedName("isPremiumUnlocked") val isPremiumUnlocked: Boolean?
) {
    val viewProgress: Int
        get() {
            return try {
                (100 * ((currentValueOfClosestToFinishCheckpoint ?: 0.0) / (targetValueOfClosestToFinishCheckpoint ?: 1.0))).toInt()
            } catch (_: Exception) {
                0
            }
        }

    val premiumCoinViewProgress: Int
        get() {
            return try {
                ceil(((Profile.profileData?.totalEarnedCoins ?: 0).toDouble() / (premiumUnlockCoinAmount ?: 1)) * 100).roundToInt()
            } catch (_: Exception) {
                0
            }
        }
}

internal enum class GamesFragmentOfferType {
    slim_slider,
    banner_with_title,
    banner_inside_label,
    horizontal_view_slider,
    banner_outside_label,
    slider_with_inside_progress,
    slider_with_outside_progress,
    list_with_progress,
    vertical_view_slider,
    slider_without_progress,
    two_column_list,
    horizontal_two_column_list,
    list_tile,
    storyly,
    footer;

    val order: Int
        get() {
            return values().indexOf(this)
        }
}