package gg.gamerewards.di;

import android.content.Context;
import dagger.internal.DaggerGenerated;
import dagger.internal.Factory;
import dagger.internal.Preconditions;
import dagger.internal.QualifierMetadata;
import dagger.internal.ScopeMetadata;
import gg.gamerewards.data.local.PrefManager;
import javax.annotation.processing.Generated;
import javax.inject.Provider;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;

@ScopeMetadata("javax.inject.Singleton")
@QualifierMetadata
@DaggerGenerated
@Generated(
    value = "dagger.internal.codegen.ComponentProcessor",
    comments = "https://dagger.dev"
)
@SuppressWarnings({
    "unchecked",
    "rawtypes",
    "KotlinInternal",
    "KotlinInternalInJava"
})
public final class ApiModule_ProvidesOkHttpClientFactory implements Factory<OkHttpClient> {
  private final ApiModule module;

  private final Provider<HttpLoggingInterceptor> httpLoggingInterceptorProvider;

  private final Provider<PrefManager> prefManagerProvider;

  private final Provider<Context> contextProvider;

  public ApiModule_ProvidesOkHttpClientFactory(ApiModule module,
      Provider<HttpLoggingInterceptor> httpLoggingInterceptorProvider,
      Provider<PrefManager> prefManagerProvider, Provider<Context> contextProvider) {
    this.module = module;
    this.httpLoggingInterceptorProvider = httpLoggingInterceptorProvider;
    this.prefManagerProvider = prefManagerProvider;
    this.contextProvider = contextProvider;
  }

  @Override
  public OkHttpClient get() {
    return providesOkHttpClient(module, httpLoggingInterceptorProvider.get(), prefManagerProvider.get(), contextProvider.get());
  }

  public static ApiModule_ProvidesOkHttpClientFactory create(ApiModule module,
      Provider<HttpLoggingInterceptor> httpLoggingInterceptorProvider,
      Provider<PrefManager> prefManagerProvider, Provider<Context> contextProvider) {
    return new ApiModule_ProvidesOkHttpClientFactory(module, httpLoggingInterceptorProvider, prefManagerProvider, contextProvider);
  }

  public static OkHttpClient providesOkHttpClient(ApiModule instance,
      HttpLoggingInterceptor httpLoggingInterceptor, PrefManager prefManager, Context context) {
    return Preconditions.checkNotNullFromProvides(instance.providesOkHttpClient(httpLoggingInterceptor, prefManager, context));
  }
}
