package gg.gamerewards.ui.base

import android.content.Intent
import android.net.Uri
import android.os.Handler
import android.provider.Settings
import androidx.viewbinding.ViewBinding
import gg.gamerewards.ui.activities.offerwallActivity.OfferwallActivity
import gg.gamerewards.utils.PermissionManager

internal abstract class BasePermissionFragment<VB : ViewBinding>() : BaseFragment<VB>() {

    private var checkUsageStatsHandler: Handler = Handler()
    private var checkUsageStatsPermission: Runnable = object : Runnable {
        override fun run() {
            if (PermissionManager.isUsageStatsPermissionGranted(requireActivity())) {
                //We have the permission, re-launch
                relaunchActivity()
                return
            }
            //Check every 0.1 second
            checkUsageStatsHandler.postDelayed(this, 100)
        }
    }

    fun relaunchActivity() {
        val i = Intent(requireContext(), OfferwallActivity::class.java)
        i.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP or Intent.FLAG_ACTIVITY_SINGLE_TOP)
        startActivity(i)
    }

    fun onClickedPermitUsageStatsPermission() {
        val intent = Intent(Settings.ACTION_USAGE_ACCESS_SETTINGS)
        runCatching {
            intent.data = Uri.parse("package:${context?.packageName}")
            startActivity(intent)
        }.onFailure {
            runCatching {
                intent.data = null
                startActivity(intent)
            }.onFailure {
                runCatching {
                    val settingsIntent = Intent(Settings.ACTION_SECURITY_SETTINGS)
                    settingsIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                    startActivity(settingsIntent)
                }.onFailure {
                }
            }
        }
        checkUsageStatsHandler.post(checkUsageStatsPermission)
    }
}