package gg.gamerewards.ui.customView

import android.content.Context
import android.graphics.drawable.Drawable
import android.util.AttributeSet
import android.view.LayoutInflater
import android.widget.FrameLayout
import androidx.appcompat.content.res.AppCompatResources
import gg.gamerewards.R
import gg.gamerewards.databinding.ViewShineAppcompatButtonBinding

/**
 * Created by Hasan Güler on 14.02.2023.
 */
internal class ShineAppCompatButton @JvmOverloads constructor(
    context: Context,
    attributeSet: AttributeSet? = null,
    defStyle: Int = 0
) : FrameLayout(context, attributeSet, defStyle) {

    private val binding = ViewShineAppcompatButtonBinding
        .inflate(LayoutInflater.from(context), this, true)

    private var shnIsEnabled: Boolean = false
    private var shnBackgroundResId: Int? = null
    private var shnText: String? = null
    private var shnDrawableStart: Drawable? = null
    private var shnDrawableEnd: Drawable? = null
    private var shnPaddingStart: Int = 0
    private var shnPaddingEnd: Int = 0

    override fun setEnabled(enabled: Boolean) {
        if (shnIsEnabled == enabled) return

        shnIsEnabled = enabled
        refreshUI()
    }

    init {
        //Obtain xml attributes
        context.obtainStyledAttributes(attributeSet, R.styleable.ShineAppCompatButton).apply {
            shnBackgroundResId =
                getResourceId(R.styleable.ShineAppCompatButton_shnButtonBackground, 0)
            shnText = getString(R.styleable.ShineAppCompatButton_shnText)
            shnDrawableStart = getDrawable(R.styleable.ShineAppCompatButton_shnDrawableStart)
            shnDrawableEnd = getDrawable(R.styleable.ShineAppCompatButton_shnDrawableEnd)
            shnPaddingStart =
                getDimensionPixelSize(R.styleable.ShineAppCompatButton_shnPaddingStart, 0)
            shnPaddingEnd = getDimensionPixelSize(R.styleable.ShineAppCompatButton_shnPaddingEnd, 0)
            shnIsEnabled = getBoolean(R.styleable.ShineAppCompatButton_shnIsEnabled, true)
            recycle()

            refreshUI()
        }

    }

    private fun refreshUI() {
        if (shnBackgroundResId != null && shnBackgroundResId != 0) {
            binding.btnAction.background =
                AppCompatResources.getDrawable(context, shnBackgroundResId!!)
        } else {
            binding.btnAction.background = null
        }

        binding.btnAction.isEnabled = shnIsEnabled
        binding.btnAction.isClickable = shnIsEnabled

        /*if (shnIsEnabled) {
            binding.shineView.root.isVisible = true
            binding.shineView.root.startShineAnimation()
            binding.btnAction.setTextAppearance(R.style.TextAppearancePurpleBlueButtonEnabled)
        } else {
            binding.shineView.root.clearAnimation()
            binding.shineView.root.isVisible = false
            binding.btnAction.setTextAppearance(R.style.TextAppearancePurpleBlueButtonDisabled)
        }*/

        binding.btnAction.text = shnText

        binding.btnAction.setCompoundDrawablesWithIntrinsicBounds(
            shnDrawableStart,
            null,
            shnDrawableEnd,
            null
        )
        binding.btnAction.setPadding(shnPaddingStart, 0, shnPaddingEnd, 0)
    }

    var text: String?
        get() {
            return shnText
        }
        set(value) {
            shnText = value
            refreshUI()
        }

    var drawableStart: Drawable?
        get() {
            return shnDrawableStart
        }
        set(value) {
            shnDrawableStart = value
            refreshUI()
        }

    var drawableEnd: Drawable?
        get() {
            return shnDrawableEnd
        }
        set(value) {
            shnDrawableEnd = value
            refreshUI()
        }

    override fun getPaddingStart(): Int {
        return shnPaddingStart
    }

    fun setPaddingStart(paddingPx: Int) {
        shnPaddingStart = paddingPx
        refreshUI()
    }

    override fun getPaddingEnd(): Int {
        return shnPaddingEnd
    }

    fun setPaddingEnd(paddingPx: Int) {
        shnPaddingEnd = paddingPx
        refreshUI()
    }

    override fun setOnClickListener(l: OnClickListener?) {
        binding.btnAction.setOnClickListener(l)
    }
}