package gg.gamerewards.ui.fragments.gameDetail

import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Bundle
import android.view.LayoutInflater
import android.widget.ImageView
import androidx.recyclerview.widget.LinearLayoutManager
import com.bumptech.glide.Glide
import gg.gamerewards.R
import gg.gamerewards.ViewModelProvider
import gg.gamerewards.data.model.response.GameDetail
import gg.gamerewards.databinding.FragmentGameDetailBinding
import gg.gamerewards.ui.base.BasePermissionFragment
import gg.gamerewards.utils.RichieUtils

/**
 * Created by Hasan Güler on 7.06.2023.
 */
internal class GameDetailFragment : BasePermissionFragment<FragmentGameDetailBinding>(),
    CheckpointTimeBasedPermissionListener {
    private val viewModel: GameDetailViewModel = ViewModelProvider.getInstance().provideGameDetailViewModel()
    private var fromTitle : String? = null

    override val bindingInflater: (LayoutInflater) -> FragmentGameDetailBinding
        get() = FragmentGameDetailBinding::inflate

    override fun setupUi(savedInstanceState: Bundle?) {
        viewModel.navigator = this
        viewModel.offerKeyId = arguments?.getString("offerKeyId")
        viewModel.offerGroupTitle = arguments?.getString("from")
        val from = arguments?.getString("from")
        fromTitle = arguments?.getString("fromTitle")
        val clickUrl = arguments?.getString("clickUrl")

        viewModel.gameDetailData.observe(this) { gameDetail ->
            if (gameDetail == null) return@observe

            /*if (!logSend) {
                getAppsFlyerImpressionRequest(gameDetail)
                if (clickUrl == STORYLY_CLICK_URL) {
                    AppsFlyerEventHelper.sendEventWithParameters(
                        fromTitle,
                        mapOf(
                            AppsFlyerEventHelper.AppsFlyerProps.STORY_NAME to from,
                            AppsFlyerEventHelper.AppsFlyerProps.PAGE_NAME to gameDetail.title
                        )
                    )
                }
                logEvent(
                    FirebaseEvents.GAME_DETAIL_SCREEN_VIEW,
                    mapOf(
                        FirebaseEventProps.FROM to (from ?: ""),
                        FirebaseEventProps.TITLE to fromTitle,
                        FirebaseEventProps.PACKAGE_NAME to (gameDetail.bundleID ?: ""),
                        FirebaseEventProps.SOURCE to (gameDetail.offerSource ?: "")
                    )
                )
                logSend = true
            }*/

            setupCheckPointRecyclerView()

            with(binding) {
                this.let {
                    context?.let { ctx ->

                        if (gameDetail.videoUrl?.contains("webp") == true) ivMedia.scaleType =
                            ImageView.ScaleType.FIT_CENTER

                        Glide.with(ctx)
                            .load(gameDetail.videoUrl)
                            .into(ivMedia)

                        Glide.with(ctx)
                            .load(gameDetail.cardIconImageUrl)
                            .circleCrop()
                            .into(ivIcon)

                        btnInstallPlay.text =
                            gameDetail.offerDetailButtonLabel ?: ctx.getString(R.string.game_detail_play_game)

                        tvTitle.text = gameDetail.title

                        btnInstallPlay.setOnClickListener {
                            /*if(gameDetail.isPlaytimeHandledByOffer == false && (gameDetail.checkpoints?.any { it.checkpointType == CheckpointViewType.TIME_BASED } == true) && (!PermissionManager.areRequiredPermissionsGranted(ctx))){
                                showPermissionDialog(gameDetail,ctx)
                            }
                            else{
                                playGameAction(gameDetail,ctx)
                            }*/
                            playGameAction(gameDetail,ctx)
                        }

                    }
                }
            }
        }

        binding.tvSeeAll.setOnClickListener {
            viewModel.gameDetailData.value?.checkpoints?.let {
                val bundle = Bundle()
                bundle.putParcelableArrayList("checkPointList", it)
                viewModel.gameDetailData.value?.isPlaytimeHandledByOffer?.let {  isPlaytimeHandledByOffer ->
                    bundle.putBoolean("isPlaytimeHandledByOffer", isPlaytimeHandledByOffer)
                }
                navigate(R.id.checkPointsSeeAllFragment,"GameDetailFragment",true,bundle)
            }
        }
    }

    private fun playGameAction(gameDetail: GameDetail, ctx: Context){
        gameDetail.bundleID.let { bundleId ->
            val isInstalled: Boolean = !bundleId.isNullOrEmpty() && RichieUtils.isAppInstalled(
                bundleId,
                ctx
            )
            if (isInstalled && !bundleId.isNullOrEmpty()) {
                val intent: Intent? =
                    ctx.packageManager?.getLaunchIntentForPackage(bundleId)
                if (intent != null) {
                    /*logEvent(
                        FirebaseEvents.GAME_OPEN,
                        mapOf(
                            FirebaseEventProps.FROM to FirebaseEventParameters.GAME_DETAIL_SCREEN,
                            FirebaseEventProps.TITLE to fromTitle
                        )
                    )
                    prefManager.isGameOpenEventSending = true*/
                    intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                    ctx.startActivity(intent)
                }
            } else if (!gameDetail.clickUrl.isNullOrEmpty()) {
                runCatching {
                    binding.btnInstallPlay.isEnabled = false
                    /*viewModel.postOfferInstallTrackingRequest(gameDetail.clickUrl,gameDetail.clickId, viewModel.offerKeyId ?: "")
                    logEvent(
                        FirebaseEvents.PLAY_STORE_PAGE_VIEW, mapOf(
                            FirebaseEventProps.FROM to FirebaseEventParameters.GAME_DETAIL_SCREEN,
                            FirebaseEventProps.PACKAGE_NAME to (gameDetail.bundleID ?: ""),
                            FirebaseEventProps.SOURCE to (gameDetail.offerSource ?: "")
                        )
                    )*/
                    startActivity(
                        Intent(
                            Intent.ACTION_VIEW,
                            Uri.parse(gameDetail.clickUrl)
                        )
                    )
                }.onFailure {
                    binding?.btnInstallPlay?.isEnabled = true
                    //activity?.asInstance(MainActivity::class)?.showConnectionWarning()
                }
            }
        }
    }

    private fun setupCheckPointRecyclerView() {
        with(binding.rvCheckpoints)
        {
            this?.let {
                val currentAdapter = adapter
                if (currentAdapter is CheckPointAdapter)
                    currentAdapter.submitList(viewModel.notCompletedCheckPoints)
                else {
                    val mAdapter = CheckPointAdapter(context,viewModel.gameDetailData.value?.isPlaytimeHandledByOffer,
                        this@GameDetailFragment, onPermitAndEarnClicked = {
                            onClickedPermitUsageStatsPermission()
                        }).apply {
                        submitList(viewModel.notCompletedCheckPoints)
                    }
                    adapter = mAdapter

                    val lManager = LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
                    layoutManager = lManager
                }
            }
        }
    }

    override fun onResume() {
        super.onResume()
        binding.btnInstallPlay?.isEnabled = true
        viewModel.getGameDetail { /*onError*/ }
    }

    override fun requestPermissions() {
        //Richie.richiePermissionRequestCallback?.requestPermissions()
    }

    /*
        private var permissionDialog: AlertDialog? = null
        var logSend = false
        private var fromTitle : String? = null
        private var exoPlayer: ExoPlayer? = null
        private var impressionHandler: Handler? = null
        private var impressionRunnable: Runnable? = null

        override fun setupUi(savedInstanceState: Bundle?) {

            viewModel.navigator = this
            val from = arguments?.getString("from")
            fromTitle = arguments?.getString("fromTitle")
            val clickUrl = arguments?.getString("clickUrl")

            viewModel.gameDetailData.observe(this) { gameDetail ->
                if (gameDetail == null) return@observe

                if (!logSend) {
                    getAppsFlyerImpressionRequest(gameDetail)
                    if (clickUrl == STORYLY_CLICK_URL) {
                        AppsFlyerEventHelper.sendEventWithParameters(
                            fromTitle,
                            mapOf(
                                AppsFlyerEventHelper.AppsFlyerProps.STORY_NAME to from,
                                AppsFlyerEventHelper.AppsFlyerProps.PAGE_NAME to gameDetail.title
                            )
                        )
                    }
                    logEvent(
                        FirebaseEvents.GAME_DETAIL_SCREEN_VIEW,
                        mapOf(
                            FirebaseEventProps.FROM to (from ?: ""),
                            FirebaseEventProps.TITLE to fromTitle,
                            FirebaseEventProps.PACKAGE_NAME to (gameDetail.bundleID ?: ""),
                            FirebaseEventProps.SOURCE to (gameDetail.offerSource ?: "")
                        )
                    )
                    logSend = true
                }

                setupCheckPointRecyclerView()

                with(binding) {
                    this?.let {
                        context?.let { ctx ->

                            if (gameDetail.videoUrl?.contains("webp") == false &&
                                gameDetail.videoUrl?.contains("png") == false &&
                                gameDetail.videoUrl?.contains("jpeg") == false &&
                                gameDetail.videoUrl?.contains("jpg") == false) {

                                playOfferVideo(ctx, gameDetail.videoUrl)
                            }else {
                                ivMedia.apply {
                                    setPlayerViewVisibility(false)

                                    if (gameDetail.videoUrl?.contains("webp") == true)
                                        scaleType = ImageView.ScaleType.FIT_CENTER

                                    Glide.with(ctx)
                                        .load(gameDetail.videoUrl)
                                        .into(this)
                                }
                            }

                            Glide.with(ctx)
                                .load(gameDetail.cardIconImageUrl)
                                .circleCrop()
                                .into(ivIcon)

                            btnInstallPlay.text =
                                gameDetail.offerDetailButtonLabel ?: ctx.getString(R.string.game_detail_play_game)


                                btnInstallPlay.setOnClickListener {
                                    if(gameDetail.isPlaytimeHandledByOffer == false && (gameDetail.checkpoints?.any { it.checkpointType == CheckpointViewType.TIME_BASED } == true) && (!PermissionManager.areRequiredPermissionsGranted(ctx))){
                                        showPermissionDialog(gameDetail,ctx)
                                    }
                                    else{
                                        playGameAction(gameDetail,ctx)
                                    }
                                }

                        }
                    }
                }
            }

            binding?.tvSeeAll?.setOnClickListener {
                viewModel.gameDetailData.value?.checkpoints?.let {
                    val bundle = Bundle()
                    bundle.putParcelableArrayList("checkPointList", it)
                    viewModel.gameDetailData.value?.isPlaytimeHandledByOffer?.let {  isPlaytimeHandledByOffer ->
                        bundle.putBoolean("isPlaytimeHandledByOffer", isPlaytimeHandledByOffer)
                    }
                    navigate(
                        GameDetailFragmentDirections.actionNavigationGameDetailToNavigationCheckpointsSeeAll(),
                        TAG,
                        true,
                        bundle
                    )
                }
            }
        }

        private fun showPermissionDialog(gameDetail: GameDetail, ctx: Context) {
            Handler(Looper.getMainLooper()).post {
                permissionDialog?.dismiss()
                permissionDialog = null
                permissionDialog =
                    AlertDialog.Builder(ctx, R.style.FullScreenAlertDialog)
                        .create()
                val view = LayoutInflater.from(ctx).inflate(R.layout.dialog_time_based_permission, null)
                view.findViewById<CardView>(R.id.cv_container).setDialogWidthPercentageBasedOnScreenSize(ctx)
                val buttonPermit = view.findViewById<AppCompatButton>(R.id.btn_ok)
                val buttonContinue = view.findViewById<AppCompatButton>(R.id.btn_cancel)
                buttonPermit.setOnClickListener {
                    permissionDialog?.dismiss()
                    activity?.asInstance(MainActivity::class)?.showPermissionDialog(ctx,FirebaseEventParameters.GAME_DETAIL_SCREEN)
                }
                buttonContinue.setOnClickListener {
                    permissionDialog?.dismiss()
                    playGameAction(gameDetail,ctx)
                }
                permissionDialog?.setView(view)
                permissionDialog?.show()
            }
        }

        private fun playGameAction(gameDetail: GameDetail, ctx: Context){
            gameDetail.bundleID.let { bundleId ->
                val isInstalled: Boolean = !bundleId.isNullOrEmpty() && RichieUtils.isAppInstalled(
                    bundleId,
                    ctx
                )
                if (isInstalled && !bundleId.isNullOrEmpty()) {
                    val intent: Intent? =
                        ctx.packageManager?.getLaunchIntentForPackage(bundleId)
                    if (intent != null) {
                        logEvent(
                            FirebaseEvents.GAME_OPEN,
                            mapOf(
                                FirebaseEventProps.FROM to FirebaseEventParameters.GAME_DETAIL_SCREEN,
                                FirebaseEventProps.TITLE to fromTitle
                            )
                        )
                        prefManager.isGameOpenEventSending = true
                        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                        ctx.startActivity(intent)
                    }
                } else if (!gameDetail.clickUrl.isNullOrEmpty()) {
                    runCatching {
                        binding?.btnInstallPlay?.isEnabled = false
                        viewModel.postOfferInstallTrackingRequest(gameDetail.clickUrl,gameDetail.clickId, viewModel.offerKeyId ?: "")
                        logEvent(
                            FirebaseEvents.PLAY_STORE_PAGE_VIEW, mapOf(
                                FirebaseEventProps.FROM to FirebaseEventParameters.GAME_DETAIL_SCREEN,
                                FirebaseEventProps.PACKAGE_NAME to (gameDetail.bundleID ?: ""),
                                FirebaseEventProps.SOURCE to (gameDetail.offerSource ?: "")
                            )
                        )
                        startActivity(
                            Intent(
                                Intent.ACTION_VIEW,
                                Uri.parse(gameDetail?.clickUrl)
                            )
                        )
                    }.onFailure {
                        binding?.btnInstallPlay?.isEnabled = true
                        activity?.asInstance(MainActivity::class)?.showConnectionWarning()
                    }
                }
            }
        }

        override fun onResume() {
            super.onResume()
            binding?.btnInstallPlay?.isEnabled = true
            viewModel.getGameDetail { *//*onError*//* }
    }

    private fun setupCheckPointRecyclerView() {
        with(binding?.rvCheckpoints)
        {
            this?.let {
                val currentAdapter = adapter
                if (currentAdapter is CheckPointAdapter)
                    currentAdapter.submitList(viewModel.notCompletedCheckPoints)
                else {
                    val mAdapter = CheckPointAdapter(context,viewModel.gameDetailData.value?.isPlaytimeHandledByOffer,this@GameDetailFragment).apply {
                        submitList(viewModel.notCompletedCheckPoints)
                    }
                    adapter = mAdapter

                    val lManager = LinearLayoutManager(context, LinearLayoutManager.VERTICAL, false)
                    layoutManager = lManager
                }
            }
        }
    }

    private fun playOfferVideo(context: Context, videoUri: String) {
        runCatching {
            if (exoPlayer == null){
                exoPlayer = ExoPlayer.Builder(context).build()
                exoPlayer?.apply {
                    repeatMode = ExoPlayer.REPEAT_MODE_ONE
                    binding?.playerView?.player = this
                    setPlayerViewVisibility(true)
                    val mediaItem = MediaItem.fromUri(videoUri)
                    setMediaItem(mediaItem)
                    prepare()
                    playWhenReady = true
                }
            } else {
                exoPlayer?.play()
            }
        }.onFailure {
            exoPlayer?.release()
        }
    }

    private fun setPlayerViewVisibility(isVideoUrl: Boolean){
        binding?.playerView?.isVisible = isVideoUrl
        binding?.ivMedia?.isVisible = !isVideoUrl
    }


    private fun getAppsFlyerImpressionRequest(gameDetail: GameDetail){
        impressionHandler = Handler(Looper.getMainLooper())
        impressionRunnable = Runnable { viewModel.getAppsflyerImpression(gameDetail.impressionURL) }
        impressionRunnable?.let {
            impressionHandler?.postDelayed(it,prefManager.appsFlyerImpressionDelay)
        }
    }

    override fun requestPermissions() {
        context?.let {  ctx ->
            activity?.asInstance(MainActivity::class)?.showPermissionDialog(ctx,
                FirebaseEventParameters.GAME_DETAIL_SCREEN)
        }
    }*/

    /*override fun onPause() {
        super.onPause()
        exoPlayer?.pause()
    }

    override fun onDestroyView() {
        super.onDestroyView()
        exoPlayer?.release()
        exoPlayer = null
    }

    override fun onDestroy() {
        super.onDestroy()
        impressionRunnable?.let { impressionHandler?.removeCallbacks(it) }
        impressionRunnable = null
        impressionHandler = null
    }
*/
}