package gg.gamerewards.ui.fragments.gameDetail

import android.util.Log
import androidx.lifecycle.MutableLiveData
import gg.gamerewards.data.api.ApiRepository
import gg.gamerewards.data.model.response.CheckPoint
import gg.gamerewards.data.model.response.GameDetail
import gg.gamerewards.ui.base.BaseNavigator
import gg.gamerewards.ui.base.BaseViewModel
import gg.gamerewards.utils.getIOScopeForAPICall
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.withContext

/**
 * Created by Hasan Güler on 16.05.2023.
 */

internal class GameDetailViewModel(private val apiRepository: ApiRepository) : BaseViewModel<BaseNavigator>() {

    var offerKeyId: String? = null
    var offerGroupTitle: String? = null
    var gameDetailData: MutableLiveData<GameDetail?> = MutableLiveData(null)
    var title: MutableLiveData<String?> = MutableLiveData(null)
    var description: MutableLiveData<String?> = MutableLiveData(null)

    val notCompletedCheckPoints: ArrayList<CheckPoint>
        get() {
            //Filter completed checkpoints
            //Filter Blockage Type Hidden
            return ArrayList(gameDetailData.value?.checkpoints?.filter { !it.isCompleted }?.flatMap { checkPoint ->
                when (checkPoint.isBlocked) {
                    true -> if (checkPoint.blockageType != BlockageType.HIDDEN.toString()) listOf(checkPoint) else emptyList()
                    else -> listOf(checkPoint)
                }
            } ?: arrayListOf())
        }

    fun getGameDetail(onError: () -> Unit) {
        if (offerKeyId.isNullOrEmpty()) {
            onError()
            return
        }
        navigator?.showLoading()
        getIOScopeForAPICall {
            val response = apiRepository.getOfferDetail(offerKeyId ?: "",offerGroupTitle ?: "")
            withContext(Dispatchers.Main) {
                if (response.isSuccessful && response.body() != null) {
                    gameDetailData.value = response.body()?.gameDetailData
                    title.value = gameDetailData.value?.title
                    description.value = gameDetailData.value?.description
                } else {
                    Log.e("GameDetailViewModel", "error")
                    onError()
                }
                navigator?.hideLoading()
            }
        }
    }

}

enum class BlockageType{
    HIDDEN,
    LOCK;

    override fun toString(): String {
        return when(this){
            HIDDEN -> "hidden"
            LOCK -> "lock"
        }
    }
}