package gg.gamerewards.ui.fragments.games.subAdapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import dagger.hilt.android.qualifiers.ApplicationContext
import gg.gamerewards.data.model.Profile
import gg.gamerewards.data.model.response.Offer
import gg.gamerewards.databinding.ItemSubMultiHorizontalAxisTwoHorizontalCardBinding
import gg.gamerewards.ui.fragments.games.GamesAdapterListener
import gg.gamerewards.utils.PremiumOfferUIHelper
import javax.inject.Inject

internal class HorizontalTwoCardWithOfferLabelListAdapter @Inject constructor(
    @ApplicationContext val context: Context,
    private var from: String?,
    private var fromTitle: String?):
    RecyclerView.Adapter<HorizontalTwoCardWithOfferLabelListAdapter.ItemMultiHorizontalAxisTwoHorizontalCardViewHolder>() {

    private var items: ArrayList<Offer> = arrayListOf()
    var listener: GamesAdapterListener? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ItemMultiHorizontalAxisTwoHorizontalCardViewHolder {
        return ItemMultiHorizontalAxisTwoHorizontalCardViewHolder(
            ItemSubMultiHorizontalAxisTwoHorizontalCardBinding.inflate(
                LayoutInflater.from(
                    parent.context
                ), parent, false
            )
        )
    }

    private fun getCurrentItem(position: Int): Offer = items[position]

    override fun getItemCount(): Int {
       return items.count()
    }

    fun submitList(addedItems: ArrayList<Offer>?) {
        this.items.clear()
        if (addedItems != null) {
            this.items = ArrayList(addedItems)
        }

        notifyDataSetChanged()
    }

    override fun onBindViewHolder(holder: ItemMultiHorizontalAxisTwoHorizontalCardViewHolder, position: Int) {
        holder.bind(getCurrentItem(position),context,listener)
    }

    inner class ItemMultiHorizontalAxisTwoHorizontalCardViewHolder(val binding: ItemSubMultiHorizontalAxisTwoHorizontalCardBinding) :
        RecyclerView.ViewHolder(binding.root) {

        fun bind(
            model: Offer,
            context: Context,
            listener: GamesAdapterListener?
        ) {
            try {
                binding.layoutPremium.apply {
                    PremiumOfferUIHelper().setUIForPremiumOffer(context,false,model,clPremiumContainer,tvUnlockCoinAmount,flPremiumLock,llPremiumUnlocked,progressBar,premiumOfferLottieView)
                }

                val isPremiumCoinEnough =
                    (Profile.profileData?.totalEarnedCoins ?: 0) >= (model.premiumUnlockCoinAmount ?: 0)
                binding.root.setOnClickListener {
                    if (model.isPremiumOffer != true || isPremiumCoinEnough)
                        listener?.onAction("${model.action}/${model.isPremiumOffer}", model.clickUrl, from, fromTitle)
                }

                Glide.with(context)
                    .load(model.verticalCardImageUrl)
                    .into(binding.ivBackground)


            } catch (_: Exception) {
            }
        }
    }

}