package gg.gamerewards.ui.fragments.games.subAdapter

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.recyclerview.widget.RecyclerView
import com.bumptech.glide.Glide
import dagger.hilt.android.qualifiers.ApplicationContext
import gg.gamerewards.R
import gg.gamerewards.data.model.response.Offer
import gg.gamerewards.databinding.ItemSubMultiVerticalAxisProgressBannerBinding
import gg.gamerewards.ui.fragments.games.GamesAdapterListener
import gg.gamerewards.utils.RichieUtils
import javax.inject.Inject


/**
 * Created by Hasan Güler on 26.05.2023.
 */
internal class MultiVerticalAxisProgressBannerAdapter @Inject constructor(@ApplicationContext val context: Context) :
    RecyclerView.Adapter<RecyclerView.ViewHolder>() {
    private var items: ArrayList<Offer> = arrayListOf()
    var listener: GamesAdapterListener? = null
    var from: String? = null
    var fromTitle: String? = null

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return ItemMultiVerticalAxisProgressBannerViewHolder(
            ItemSubMultiVerticalAxisProgressBannerBinding.inflate(
                LayoutInflater.from(
                    parent.context
                ), parent, false
            )
        )
    }

    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        val currentItem = getCurrentItem(position)
        when (holder) {
            is ItemMultiVerticalAxisProgressBannerViewHolder -> holder.bind(currentItem, context, listener)
        }
    }

    private fun getCurrentItem(position: Int): Offer = items[position]

    override fun getItemCount(): Int = items.count()

    fun submitList(addedItems: ArrayList<Offer>?) {
        this.items.clear()
        if (addedItems != null) {
            this.items = ArrayList(addedItems)
        }

        notifyDataSetChanged()
    }

    inner class ItemMultiVerticalAxisProgressBannerViewHolder(val binding: ItemSubMultiVerticalAxisProgressBannerBinding) :
        RecyclerView.ViewHolder(binding.root) {

        fun bind(
            model: Offer,
            context: Context,
            listener: GamesAdapterListener?
        ) {
            try {

                Glide.with(context)
                    .load(model.cardIconImageUrl)
                    .into(binding.ivIcon)

                if (!model.cardBackgroundColor.isNullOrEmpty()) {
                    binding.cvContainer.setCardBackgroundColor(RichieUtils.parseColor("#${model.cardBackgroundColor}"))
                } else {
                    binding.cvContainer.setCardBackgroundColor(ContextCompat.getColor(context, R.color.transparent))
                }

                binding.tvTitle.text = model.title
                binding.tvSubtitle.text = model.subtitle
                binding.cvActionButton.setCardBackgroundColor(RichieUtils.parseColor("#${model.actionButtonBackgroundColor}"))
                binding.tvActionButton.text = model.actionButtonTitle
                binding.tvActionButton.setTextColor(RichieUtils.parseColor("#${model.actionButtonTextColor}"))

                binding.progressBar.progress = model.viewProgress
                binding.tvProgressStartValue.text = (model.currentValueOfClosestToFinishCheckpoint ?: 0.0).toInt().toString()
                binding.tvProgressEndValue.text = (model.targetValueOfClosestToFinishCheckpoint ?: 0.0).toInt().toString()

                binding.root.setOnClickListener {
                    listener?.onAction(model.action, model.clickUrl, from, fromTitle)
                }
            } catch (_: Exception) {
            }
        }
    }
}
