package gg.gamerewards.utils

class CompactNumberFormatter {
    fun format(number: Long?): String {
        return if (number != null) {
            when {
                number >= 1_000_000_000_000 -> "${number / 1_000_000_000_000}T"
                number >= 1_000_000_000 -> "${number / 1_000_000_000}B"
                number >= 1_000_000 -> "${number / 1_000_000}M"

                else -> number.toString()
            }
        } else
            ""
    }
}