package gg.gamerewards.utils

import android.util.Base64
import java.security.Key
import javax.crypto.Cipher
import javax.crypto.spec.IvParameterSpec
import javax.crypto.spec.SecretKeySpec


internal object Cryptor {
    private const val ALGO = "AES/CBC/PKCS5Padding"
    private const val keyString = "Cihangir-Kennedy"
    private val keyValue = keyString.toByteArray()
    private const val keyString2 = "C1hang1r-K3nn3dy"
    private val keyValue2 = keyString2.toByteArray()
    private val iv = byteArrayOf(5, 2, 1, 7, 3, 4, 2, 1, 0, 4, 0, 2, 6, 9, 9, 2)

    /**
     * Encrypt a string with AES algorithm.
     *
     * @param data is a string
     * @return the encrypted string
     */
    fun encrypt(data: String, withV2: Boolean): String {
        var key: Key? = null
        return try {
            key = generateKey(withV2)
            val c = Cipher.getInstance(ALGO)
            val ivspec = IvParameterSpec(iv)
            c.init(Cipher.ENCRYPT_MODE, key, ivspec)
            val encVal = c.doFinal(data.toByteArray(charset("UTF-8")))
            Base64.encodeToString(encVal, Base64.NO_WRAP)
        } catch (e: Exception) {
            e.printStackTrace()
            ""
        }
    }

    /**
     * Decrypt a string with AES algorithm.
     *
     * @param encryptedData is a string
     * @return the decrypted string
     */
    fun decrypt(encryptedData: String?): String {
        return try {
            val key = generateKey(false)
            val c = Cipher.getInstance(ALGO)
            // build the initialization vector.  This example is all zeros, but it
            // could be any value or generated using a random number generator.
            val ivspec = IvParameterSpec(iv)
            c.init(Cipher.DECRYPT_MODE, key, ivspec)
            val decordedValue = Base64.decode(encryptedData, Base64.NO_WRAP)
            val decValue = c.doFinal(decordedValue)
            String(decValue, charset("UTF-8"))
        } catch (e: Exception) {
            e.printStackTrace()
            ""
        }
    }

    /**
     * Generate a new encryption key.
     */
    @Throws(Exception::class)
    private fun generateKey(withV2: Boolean): Key {
        return if (withV2) SecretKeySpec(keyValue2, "AES") else SecretKeySpec(
            keyValue, "AES"
        )
    }
}