package gg.gamerewards.utils

import android.util.DisplayMetrics
import android.util.Log
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.LinearSmoothScroller
import androidx.recyclerview.widget.RecyclerView
import java.util.TimerTask

internal class CustomAutoSliderTimerTask(private val recyclerView: RecyclerView) : TimerTask() {
    private var lManager = recyclerView.layoutManager as LinearLayoutManager?
    private var lastItemSeen = false
    private var targetPosition = 0

    override fun cancel(): Boolean {
        lManager = null
        return super.cancel()
    }

    override fun run() {
        try {
            val currentPosition = lManager?.findLastCompletelyVisibleItemPosition() ?: return
            val itemCount = recyclerView.adapter?.itemCount ?: 0

            if (currentPosition == -1){
                return
            }

            if (currentPosition == itemCount -1)
                lastItemSeen = true

            if (!lastItemSeen){
                if (currentPosition < itemCount -1)
                    targetPosition = currentPosition +1
            } else {
                targetPosition = currentPosition -1
                if (currentPosition == 0)
                    lastItemSeen = false
            }

            val smoothScroller: RecyclerView.SmoothScroller = object : LinearSmoothScroller(recyclerView.context) {
                override fun calculateSpeedPerPixel(displayMetrics: DisplayMetrics): Float {
                    return 150f / displayMetrics.densityDpi
                }
            }

            smoothScroller.targetPosition = targetPosition
            lManager?.startSmoothScroll(smoothScroller)
        }catch (e: OutOfMemoryError){
            cancel()
        }catch (e:Exception){
            e.message?.let { Log.e("CustomAutoSliderTimerTask", it) }
        }
    }
}
