package gg.gamerewards.utils
import android.app.AlertDialog
import android.content.Context
import android.os.Bundle
import android.view.LayoutInflater
import com.bumptech.glide.Glide
import com.bumptech.glide.load.resource.bitmap.CircleCrop
import com.bumptech.glide.request.target.Target
import gg.gamerewards.R
import gg.gamerewards.databinding.LockedCheckpointDialogBinding

class LockedCheckpointDialog(
    private val ctx: Context,
    private val iconUrl : String?,
    private val title: String?,
    private val subTitleText: String?,
    private val blockedCheckpointReasonText: String?,
) : AlertDialog(ctx, R.style.fullScreenDialogWithDim) {

    private var binding: LockedCheckpointDialogBinding? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setCancelable(false)
        val inflater = context.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
        binding = LockedCheckpointDialogBinding.inflate(inflater)
        binding?.apply {
            cvContainer.setDialogWidthPercentageBasedOnScreenSize(ctx)
            Glide.with(ctx)
                .load(iconUrl)
                .transform(CircleCrop(),CircleBorderTransformation())
                .override(Target.SIZE_ORIGINAL)
                .into(ivIcon)
            tvTitle.text = title
            tvSubTitle.text = subTitleText
            tvReasonText.text = blockedCheckpointReasonText
            setContentView(root)
        }

        binding?.btnClose?.setOnClickListener {
            dismiss()
        }
    }
}