package gg.gamerewards.utils

import android.os.Bundle
import androidx.navigation.NavDirections
import androidx.navigation.NavOptions
import gg.gamerewards.R

object NavigationExtensions {

    class NavigationObject(val navOptions: NavOptions, val newDirection: NavDirections)

    fun prepareNavigationObjects(
        directions: Int,
        redirectFrom: String?,
        presentToUp: Boolean = false,
        extras: Bundle? = null
    ): NavigationObject {
        val newArgs = Bundle().apply {
            extras?.let { putAll(extras) }
            putString(Constants.EXTRA_REDIRECT, redirectFrom)
        }

        val navOptions = androidx.navigation.navOptions {
            if (presentToUp) {
                anim {
                    enter = R.anim.slide_to_up
                    popExit = R.anim.slide_to_down
                }
            } else {
                anim {
                    enter = R.anim.fragment_in
                    exit = R.anim.fragment_out
                    popEnter = R.anim.fragment_pop_in
                    popExit = R.anim.fragment_pop_out
                }
            }
            launchSingleTop = true
        }


        val newDirection = object : NavDirections {
            override val actionId = directions
            override val arguments = newArgs
        }

        return NavigationObject(navOptions, newDirection)
    }
}