package gg.gamerewards.utils

import android.app.AppOpsManager
import android.content.Context
import android.content.Intent
import android.net.Uri
import android.os.Build
import android.provider.Settings
import androidx.activity.result.ActivityResultLauncher

object PermissionManager {

    fun isUsageStatsPermissionGranted(context: Context?): Boolean {
        if (context == null) return false

        val appOpsManager = context.getSystemService(Context.APP_OPS_SERVICE) as AppOpsManager

        val mode: Int = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            appOpsManager.unsafeCheckOpNoThrow(
                AppOpsManager.OPSTR_GET_USAGE_STATS,
                android.os.Process.myUid(),
                context.packageName
            )
        } else {
            appOpsManager.checkOpNoThrow(
                AppOpsManager.OPSTR_GET_USAGE_STATS,
                android.os.Process.myUid(),
                context.packageName
            )
        }
        return mode == AppOpsManager.MODE_ALLOWED
    }

    fun areRequiredPermissionsGranted(ctx: Context): Boolean {
        return isUsageStatsPermissionGranted(ctx)
    }


    fun askForUsageStats(usageStatsResultLauncher: ActivityResultLauncher<Intent>,context: Context?) {
        val intent = Intent(Settings.ACTION_USAGE_ACCESS_SETTINGS)
        context?.apply {
            runCatching {
                intent.data = Uri.parse("package:$packageName")
                usageStatsResultLauncher.launch(intent)
            }.onFailure {
                runCatching {
                    intent.data = null
                    usageStatsResultLauncher.launch(intent)
                }.onFailure {
                    runCatching {
                        val settingsIntent = Intent(Settings.ACTION_SECURITY_SETTINGS)
                        settingsIntent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                        startActivity(settingsIntent)
                    }
                }
            }
            //checkUsageStatsHandler.post(checkUsageStatsPermission)
        }
    }
}