package gg.gamerewards.utils

import android.content.Context
import android.widget.FrameLayout
import android.widget.LinearLayout
import android.widget.ProgressBar
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.core.view.isVisible
import com.airbnb.lottie.LottieAnimationView
import gg.gamerewards.R
import gg.gamerewards.data.model.Profile
import gg.gamerewards.data.model.response.Offer

internal class PremiumOfferUIHelper {

    fun setUIForPremiumOffer(
        context: Context,
        isVerticalCard:Boolean,
        model: Offer,
        clPremiumContainer: ConstraintLayout,
        tvUnlockCoinAmount: TextView,
        premiumLockLayout: FrameLayout,
        premiumUnlocked: LinearLayout,
        progressBar: ProgressBar,
        lottieView: LottieAnimationView
    ) {
        val isPremiumCoinEnough =
            (Profile.profileData?.totalEarnedCoins ?: 0) >= (model.premiumUnlockCoinAmount ?: 0)
        val isOfferPremium = (model.isPremiumOffer ?: false) && (!(model.isPremiumUnlocked ?: true) || !isPremiumCoinEnough)
        progressBar.progress = model.premiumCoinViewProgress
        tvUnlockCoinAmount.text = if (isVerticalCard) context.getString(R.string.premium_offer_unlock_text_vertical,model.premiumUnlockCoinAmount.toString()) else context.getString(
            R.string.premium_offer_unlock_text_horizontal,model.premiumUnlockCoinAmount.toString())
        if (isOfferPremium){
            if (!isVerticalCard && isPremiumCoinEnough)
                lottieView.setMargins(bottom = context.dpToPx(40))
            lottieView.setAnimation(
                if (isPremiumCoinEnough) R.raw.premium_offer_unlock_anim else R.raw.premium_offer_lock_anim)
            lottieView.playAnimation()
        }
        clPremiumContainer.isVisible = isOfferPremium
        isPremiumCoinEnough.apply {
            premiumLockLayout.isVisible = !this
            premiumUnlocked.isVisible =  this
        }
    }
}