package gg.gamerewards.utils;


import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;

public class RandomStringGenerator {

    private static final String CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    private static String generate(int length) {
        StringBuilder builder = new StringBuilder(length);
        Random rnd = ThreadLocalRandom.current();

        for (int i = 0; i < length; i++) {
            int index = rnd.nextInt(CHARS.length());
            builder.append(CHARS.charAt(index));
        }

        return builder.toString();
    }

    public static String generateWithTimestamp(Long timeStamp) {
        String randomPart = generate(4);
        //long timestamp = Instant.now().atZone(ZoneId.systemDefault()).toEpochSecond();
        return randomPart + timeStamp;
    }

}


