package gg.gamerewards.utils

import android.content.Context
import android.util.Log
import android.view.View
import androidx.constraintlayout.widget.ConstraintLayout
 fun View.setDialogWidthPercentageBasedOnScreenSize(context: Context){
        /**
         * This code is designed to adjust the width percentage of dialogues.
         * The percentage is set to 60% for larger screens to ensure proper appearance and 90% for regular screens."
         * */
        runCatching {
            val params = layoutParams as ConstraintLayout.LayoutParams
            params.matchConstraintPercentWidth = if (context.isLargeScreen()) 0.6f else 0.90f
            layoutParams = params
        }.onFailure {
            Log.d("ViewExt",it.message,it)
        }
    }