/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler.kotlin;

import gg.jte.ContentType;
import gg.jte.TemplateConfig;
import gg.jte.TemplateException;
import gg.jte.compiler.ClassDefinition;
import gg.jte.compiler.CodeBuilder;
import gg.jte.compiler.CodeGenerator;
import gg.jte.compiler.ParamInfo;
import gg.jte.compiler.TemplateCompiler;
import gg.jte.compiler.TemplateDependency;
import gg.jte.compiler.TemplateParser;
import gg.jte.compiler.TemplateParserVisitor;
import gg.jte.compiler.kotlin.KotlinParamInfo;
import gg.jte.runtime.ClassInfo;
import gg.jte.runtime.DebugInfo;
import gg.jte.runtime.TemplateType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class KotlinCodeGenerator
implements CodeGenerator {
    private final TemplateCompiler compiler;
    private final TemplateConfig config;
    private final ConcurrentHashMap<String, List<ParamInfo>> paramOrder;
    private final ClassInfo classInfo;
    private final CodeBuilder kotlinCode = new CodeBuilder();
    private final LinkedHashSet<ClassDefinition> classDefinitions;
    private final LinkedHashSet<TemplateDependency> templateDependencies;
    private final List<ParamInfo> parameters = new ArrayList<ParamInfo>();
    private final List<byte[]> binaryTextParts = new ArrayList<byte[]>();
    private boolean hasWrittenPackage;
    private boolean hasWrittenClass;

    public KotlinCodeGenerator(TemplateCompiler compiler, TemplateConfig config, ConcurrentHashMap<String, List<ParamInfo>> paramOrder, ClassInfo classInfo, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<TemplateDependency> templateDependencies) {
        this.compiler = compiler;
        this.config = config;
        this.paramOrder = paramOrder;
        this.classInfo = classInfo;
        this.classDefinitions = classDefinitions;
        this.templateDependencies = templateDependencies;
    }

    public void onImport(String importClass) {
        this.writePackageIfRequired();
        this.kotlinCode.append("import ").append(importClass).append("\n");
    }

    private void writePackageIfRequired() {
        if (!this.hasWrittenPackage) {
            this.kotlinCode.append("package " + this.classInfo.packageName + "\n");
            this.hasWrittenPackage = true;
        }
    }

    public void onParam(String parameter) {
        ParamInfo paramInfo = KotlinParamInfo.parse(parameter, (TemplateParserVisitor)this, this.kotlinCode.getCurrentTemplateLine());
        this.writePackageIfRequired();
        if (!this.hasWrittenClass) {
            this.writeClass();
        }
        this.kotlinCode.append(", ");
        if (paramInfo.varargs) {
            this.kotlinCode.append("vararg ");
        }
        this.kotlinCode.append(paramInfo.name).append(':').append(paramInfo.type);
        this.parameters.add(paramInfo);
    }

    private void writeClass() {
        this.kotlinCode.append("class ").append(this.classInfo.className).append(" {\n");
        this.kotlinCode.append("companion object {\n");
        this.kotlinCode.markFieldsIndex();
        this.kotlinCode.append("\t@JvmStatic fun render(");
        this.writeTemplateOutputParam();
        this.kotlinCode.append(", jteHtmlInterceptor:gg.jte.html.HtmlInterceptor?");
        this.hasWrittenClass = true;
    }

    private String getContentClass() {
        if (this.config.contentType == ContentType.Html) {
            return "gg.jte.html.HtmlContent";
        }
        return "gg.jte.Content";
    }

    private void writeTemplateOutputParam() {
        if (this.config.contentType == ContentType.Html) {
            this.kotlinCode.append("jteOutput:gg.jte.html.HtmlTemplateOutput");
        } else {
            this.kotlinCode.append("jteOutput:gg.jte.TemplateOutput");
        }
    }

    public void onParamsComplete() {
        this.writePackageIfRequired();
        if (!this.hasWrittenClass) {
            this.writeClass();
        }
        this.kotlinCode.append(") {\n");
        this.paramOrder.put(this.classInfo.name, this.parameters);
    }

    public void onLineFinished() {
        this.kotlinCode.finishTemplateLine();
    }

    public void onComplete() {
        int lineCount = 2;
        if (!this.binaryTextParts.isEmpty()) {
            lineCount += this.binaryTextParts.size() + 1;
        }
        this.kotlinCode.insertFieldLines(lineCount);
        StringBuilder fields = new StringBuilder(64 + 32 * lineCount);
        this.addNameField(fields, this.classInfo.name);
        this.addLineInfoField(fields);
        this.writeBinaryTextParts(fields);
        this.kotlinCode.insertFields(fields);
        this.kotlinCode.append("\t}\n");
        this.kotlinCode.append("\t@JvmStatic fun renderMap(");
        this.writeTemplateOutputParam();
        this.kotlinCode.append(", jteHtmlInterceptor:gg.jte.html.HtmlInterceptor?");
        this.kotlinCode.append(", params:Map<String, Any?>) {\n");
        for (ParamInfo parameter : this.parameters) {
            if (parameter.varargs) continue;
            this.kotlinCode.setCurrentTemplateLine(parameter.templateLine);
            this.kotlinCode.append("\t\tval ").append(parameter.name).append(" = params[\"").append(parameter.name).append("\"] as ").append(parameter.type);
            if (parameter.defaultValue != null) {
                this.kotlinCode.append("? ?: ");
                this.writeCodeWithContentSupport(0, parameter.defaultValue);
            }
            this.kotlinCode.append('\n');
        }
        this.kotlinCode.append("\t\trender(jteOutput, jteHtmlInterceptor");
        for (ParamInfo parameter : this.parameters) {
            if (parameter.varargs) continue;
            this.kotlinCode.append(", ").append(parameter.name);
        }
        this.kotlinCode.append(");\n");
        this.kotlinCode.append("\t}\n");
        this.kotlinCode.append("}\n");
        this.kotlinCode.append("}\n");
        this.classInfo.lineInfo = this.kotlinCode.getLineInfo();
    }

    private void addNameField(StringBuilder fields, String name) {
        fields.append("\t@JvmField val ").append("JTE_NAME").append(" = \"");
        fields.append(name);
        fields.append("\"\n");
    }

    private void addLineInfoField(StringBuilder fields) {
        fields.append("\t@JvmField val ").append("JTE_LINE_INFO").append(" = intArrayOf(");
        for (int i = 0; i < this.kotlinCode.getCurrentCodeLine(); ++i) {
            if (i > 0) {
                fields.append(',');
            }
            fields.append(this.kotlinCode.getLineInfo(i));
        }
        fields.append(")\n");
    }

    private void writeBinaryTextParts(StringBuilder fields) {
        if (this.binaryTextParts.isEmpty()) {
            return;
        }
        this.writeBinaryTextPartsContent(fields);
        this.writeBinaryTextPartsConstants(fields);
    }

    private void writeBinaryTextPartsContent(StringBuilder fields) {
        String contentFileName = new ClassDefinition(this.classInfo.className, "kt").getBinaryTextPartsFileName();
        fields.append("\t@JvmStatic val BINARY_CONTENT = gg.jte.runtime.BinaryContent.load(").append(this.classInfo.className).append(".javaClass, \"").append(contentFileName).append("\", ");
        for (int i = 0; i < this.binaryTextParts.size(); ++i) {
            if (i > 0) {
                fields.append(',');
            }
            fields.append(this.binaryTextParts.get(i).length);
        }
        fields.append(");\n");
    }

    private void writeBinaryTextPartsConstants(StringBuilder fields) {
        for (int i = 0; i < this.binaryTextParts.size(); ++i) {
            fields.append("\t@JvmStatic val ").append("TEXT_PART_BINARY_").append(i).append(" = BINARY_CONTENT.get(").append(i).append(")\n");
        }
    }

    public void onError(String message) {
        DebugInfo debugInfo = this.getCurrentDebugInfo();
        throw new TemplateException("Failed to compile " + debugInfo.name + ", error at line " + debugInfo.line + ": " + message);
    }

    public void onTextPart(int depth, String textPart) {
        if (textPart.isEmpty()) {
            return;
        }
        if (this.config.binaryStaticContent) {
            this.writeTextBinary(depth, textPart);
        } else {
            this.writeTextString(depth, textPart);
        }
    }

    private void writeTextBinary(int depth, String textPart) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.writeBinaryContent(");
        this.kotlinCode.append("TEXT_PART_BINARY_").append(this.binaryTextParts.size());
        this.kotlinCode.append(")\n");
        byte[] bytes = textPart.getBytes(StandardCharsets.UTF_8);
        this.binaryTextParts.add(bytes);
    }

    private void writeTextString(int depth, String textPart) {
        int length = textPart.length();
        if (length < 10922) {
            this.writeText(depth, textPart);
        } else {
            int modifiedUtf8Length = 0;
            int chunkOffset = 0;
            for (int i = 0; i < length; ++i) {
                char c = textPart.charAt(i);
                if (c >= '\u0080' || c == '\u0000') {
                    modifiedUtf8Length += c >= '\u0800' ? 2 : 1;
                }
                if (c >= '\ud800' && c <= '\udbff' || modifiedUtf8Length + (i - chunkOffset + 1) <= 65529) continue;
                this.writeText(depth, textPart.substring(chunkOffset, i + 1));
                modifiedUtf8Length = 0;
                chunkOffset = i + 1;
            }
            if (chunkOffset < length) {
                this.writeText(depth, textPart.substring(chunkOffset));
            }
        }
    }

    private void writeText(int depth, String text) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.writeContent(\"");
        this.kotlinCode.appendEscaped(text);
        this.kotlinCode.append("\")\n");
    }

    public void onCodePart(int depth, String codePart) {
        this.writeCodePart(depth, codePart);
    }

    public void onHtmlTagBodyCodePart(int depth, String codePart, String tagName) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.setContext(\"").append(tagName).append("\", null)\n");
        this.writeCodePart(depth, codePart);
    }

    public void onHtmlTagAttributeCodePart(int depth, String codePart, String tagName, String attributeName) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.setContext(\"").append(tagName).append("\", \"").append(attributeName).append("\")\n");
        this.writeCodePart(depth, codePart);
    }

    public void onUnsafeCodePart(int depth, String codePart) {
        if (this.config.contentType == ContentType.Html) {
            this.writeIndentation(depth);
            this.kotlinCode.append("jteOutput.setContext(null, null)\n");
        }
        this.writeCodePart(depth, codePart);
    }

    private void writeCodePart(int depth, String codePart) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.writeUserContent(");
        this.writeCodeWithContentSupport(depth, codePart);
        this.kotlinCode.append(")\n");
    }

    public void onCodeStatement(int depth, String codePart) {
        this.writeIndentation(depth);
        this.writeCodeWithContentSupport(depth, codePart);
        this.kotlinCode.append("\n");
    }

    public void onConditionStart(int depth, String condition) {
        this.writeIndentation(depth);
        this.kotlinCode.append("if (");
        this.kotlinCode.append(condition);
        this.kotlinCode.append(") {\n");
    }

    public void onConditionElse(int depth, String condition) {
        this.writeIndentation(depth);
        this.kotlinCode.append("} else if (");
        this.kotlinCode.append(condition);
        this.kotlinCode.append(") {\n");
    }

    public void onConditionElse(int depth) {
        this.writeIndentation(depth);
        this.kotlinCode.append("} else {\n");
    }

    public void onConditionEnd(int depth) {
        this.writeIndentation(depth);
        this.kotlinCode.append("}\n");
    }

    public void onForLoopStart(int depth, String codePart) {
        this.writeIndentation(depth);
        this.kotlinCode.append("for (").append(codePart).append(") {\n");
    }

    public void onForLoopEnd(int depth) {
        this.writeIndentation(depth);
        this.kotlinCode.append("}\n");
    }

    public void onTag(int depth, TemplateType type, String name, List<String> params) {
        ClassInfo tagInfo = this.compiler.generateTagOrLayout(type, name, "kte", this.classDefinitions, this.templateDependencies, this.getCurrentDebugInfo());
        this.writeIndentation(depth);
        this.kotlinCode.append(tagInfo.fullName).append(".render(jteOutput, jteHtmlInterceptor");
        this.appendParams(depth, tagInfo.name, params);
        this.kotlinCode.append(");\n");
    }

    public void onInterceptHtmlTagOpened(int depth, TemplateParser.HtmlTag htmlTag) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteHtmlInterceptor?.onHtmlTagOpened(\"").append(htmlTag.name).append("\", ");
        this.writeAttributeMap(htmlTag);
        this.kotlinCode.append(", jteOutput)\n");
    }

    public void onInterceptHtmlAttributeStarted(int depth, TemplateParser.HtmlTag currentHtmlTag, TemplateParser.HtmlAttribute htmlAttribute) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteHtmlInterceptor?.onHtmlAttributeStarted(\"").append(htmlAttribute.name).append("\", ");
        this.writeAttributeMap(currentHtmlTag);
        this.kotlinCode.append(", jteOutput)\n");
    }

    public void onInterceptHtmlTagClosed(int depth, TemplateParser.HtmlTag htmlTag) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteHtmlInterceptor?.onHtmlTagClosed(\"").append(htmlTag.name).append("\", jteOutput)\n");
    }

    public void onHtmlAttributeOutput(int depth, TemplateParser.HtmlTag currentHtmlTag, TemplateParser.HtmlAttribute htmlAttribute) {
        String javaExpression = CodeGenerator.extractTemplateExpression((String)htmlAttribute.value);
        if (htmlAttribute.bool) {
            this.onConditionStart(depth, javaExpression);
            this.onTextPart(depth, " " + htmlAttribute.name);
        } else {
            this.onConditionStart(depth, "gg.jte.runtime.TemplateUtils.isAttributeRendered(" + javaExpression + ")");
            this.onTextPart(depth + 1, " " + htmlAttribute.name + "=" + htmlAttribute.quotes);
            this.onHtmlTagAttributeCodePart(depth + 1, javaExpression, currentHtmlTag.name, htmlAttribute.name);
            this.onTextPart(depth + 1, "" + htmlAttribute.quotes);
        }
        this.onConditionEnd(depth);
    }

    private void writeAttributeMap(TemplateParser.HtmlTag htmlTag) {
        CodeGenerator.writeAttributeMap((CodeBuilder)this.kotlinCode, (TemplateParser.HtmlTag)htmlTag);
    }

    private void writeCodeWithContentSupport(int depth, String code) {
        if (code.contains("@`")) {
            new ContentProcessor(depth, code).process();
        } else {
            this.kotlinCode.append(code);
        }
    }

    private DebugInfo getCurrentDebugInfo() {
        return new DebugInfo(this.classInfo.name, this.kotlinCode.getCurrentTemplateLine() + 1);
    }

    private void appendParams(int depth, String name, List<String> params) {
        List<ParamInfo> paramInfos = this.paramOrder.get(name);
        if (paramInfos == null) {
            throw new IllegalStateException("No parameter information for " + name);
        }
        int index = 0;
        ParamCallInfo[] paramCallInfos = new ParamCallInfo[Math.max(params.size(), paramInfos.size())];
        for (String param : params) {
            ParamCallInfo paramCallInfo = new ParamCallInfo(param);
            int parameterIndex = this.getParameterIndex(name, paramInfos, paramCallInfo);
            if (parameterIndex == -1) {
                parameterIndex = index;
            }
            paramCallInfos[parameterIndex] = paramCallInfo;
            ++index;
        }
        for (int i = 0; i < paramCallInfos.length; ++i) {
            ParamCallInfo paramCallInfo = paramCallInfos[i];
            if (paramCallInfo != null) {
                this.appendParam(depth, paramCallInfo.data);
                continue;
            }
            ParamInfo paramInfo = paramInfos.get(i);
            if (paramInfo.defaultValue == null) continue;
            this.appendParam(depth, paramInfo.defaultValue);
        }
    }

    private void appendParam(int depth, String param) {
        this.kotlinCode.append(", ");
        this.writeCodeWithContentSupport(depth, param);
    }

    private int getParameterIndex(String name, List<ParamInfo> paramInfos, ParamCallInfo paramCallInfo) {
        if (paramCallInfo.name == null) {
            return -1;
        }
        for (int i = 0; i < paramInfos.size(); ++i) {
            if (!paramInfos.get((int)i).name.equals(paramCallInfo.name)) continue;
            return i;
        }
        throw new TemplateException("Failed to compile template, error at " + this.classInfo.name + ":" + this.kotlinCode.getCurrentTemplateLine() + ". No parameter with name " + paramCallInfo.name + " is defined in " + name);
    }

    private void writeIndentation(int depth) {
        for (int i = 0; i < depth + 2; ++i) {
            this.kotlinCode.append('\t');
        }
    }

    public String getCode() {
        return this.kotlinCode.getCode();
    }

    public List<byte[]> getBinaryTextParts() {
        return this.binaryTextParts;
    }

    private static final class ParamCallInfo {
        final String name;
        final String data;

        public ParamCallInfo(String param) {
            param = param.trim();
            int nameEndIndex = -1;
            int dataStartIndex = -1;
            for (int i = 0; i < param.length(); ++i) {
                char character = param.charAt(i);
                if (nameEndIndex == -1) {
                    if (character == '\"' || character == '\'') break;
                    if (character != '=') continue;
                    nameEndIndex = i;
                    continue;
                }
                if (dataStartIndex != -1 || Character.isWhitespace(character)) continue;
                dataStartIndex = i;
            }
            if (nameEndIndex != -1 && dataStartIndex != -1) {
                this.name = param.substring(0, nameEndIndex).trim();
                this.data = param.substring(dataStartIndex).trim();
            } else {
                this.name = null;
                this.data = param;
            }
        }
    }

    class ContentProcessor {
        private final int depth;
        private final String param;
        private int startIndex = -1;
        private int endIndex = -1;
        private int lastWrittenIndex = -1;
        private int nestedCount;
        private char previousChar0;
        private char currentChar;

        ContentProcessor(int depth, String param) {
            this.depth = depth;
            this.param = param;
        }

        public void process() {
            for (int i = 0; i < this.param.length(); ++i) {
                this.previousChar0 = this.currentChar;
                this.currentChar = this.param.charAt(i);
                if (this.previousChar0 == '@' && this.currentChar == '`') {
                    if (this.startIndex == -1) {
                        this.startIndex = i + 1;
                        continue;
                    }
                    ++this.nestedCount;
                    continue;
                }
                if (this.currentChar != '`') continue;
                if (this.nestedCount == 0) {
                    this.endIndex = i;
                    this.writeCode();
                    continue;
                }
                --this.nestedCount;
            }
            if (this.lastWrittenIndex + 1 < this.param.length()) {
                KotlinCodeGenerator.this.kotlinCode.append(this.param, this.lastWrittenIndex + 1, this.param.length());
            }
        }

        private void writeCode() {
            KotlinCodeGenerator.this.kotlinCode.append(this.param, this.lastWrittenIndex + 1, this.startIndex - 2);
            KotlinCodeGenerator.this.kotlinCode.append("object : ").append(KotlinCodeGenerator.this.getContentClass()).append(" {\n");
            KotlinCodeGenerator.this.writeIndentation(this.depth + 1);
            KotlinCodeGenerator.this.kotlinCode.append("override fun writeTo(");
            KotlinCodeGenerator.this.writeTemplateOutputParam();
            KotlinCodeGenerator.this.kotlinCode.append(") {\n");
            TemplateParser parser = new TemplateParser(this.param, TemplateType.Content, (TemplateParserVisitor)KotlinCodeGenerator.this, KotlinCodeGenerator.this.config);
            parser.setStartIndex(this.startIndex);
            parser.setEndIndex(this.endIndex);
            parser.setParamsComplete(true);
            parser.parse(this.depth + 2);
            KotlinCodeGenerator.this.writeIndentation(this.depth + 1);
            KotlinCodeGenerator.this.kotlinCode.append("}\n");
            KotlinCodeGenerator.this.writeIndentation(this.depth);
            KotlinCodeGenerator.this.kotlinCode.append("}");
            this.lastWrittenIndex = this.endIndex;
            this.startIndex = -1;
            this.endIndex = -1;
        }
    }
}

