/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler.kotlin;

import gg.jte.compiler.ParamInfo;
import gg.jte.compiler.TemplateParserVisitor;

public final class KotlinParamInfo {
    private KotlinParamInfo() {
    }

    public static ParamInfo parse(String parameterString, TemplateParserVisitor visitor, int templateLine) {
        int i;
        boolean varargs = parameterString.startsWith("vararg");
        int nameStartIndex = -1;
        int nameEndIndex = -1;
        int typeStartIndex = -1;
        int typeEndIndex = -1;
        int defaultValueStartIndex = -1;
        int genericDepth = 0;
        int n = i = varargs ? 7 : 0;
        while (i < parameterString.length()) {
            char character = parameterString.charAt(i);
            if (character == '<') {
                ++genericDepth;
            } else if (character == '>') {
                --genericDepth;
            }
            if (genericDepth <= 0) {
                if (nameStartIndex == -1) {
                    if (!Character.isWhitespace(character)) {
                        nameStartIndex = i;
                    }
                } else if (nameEndIndex == -1) {
                    if (Character.isWhitespace(character) || character == ':') {
                        nameEndIndex = i;
                    }
                } else if (typeStartIndex == -1) {
                    if (!Character.isWhitespace(character) && character != ':') {
                        typeStartIndex = i;
                    }
                } else if (typeEndIndex == -1) {
                    if (Character.isWhitespace(character) || character == '=') {
                        typeEndIndex = i;
                    } else if (i == parameterString.length() - 1) {
                        typeEndIndex = i + 1;
                        break;
                    }
                } else if (defaultValueStartIndex == -1 && !Character.isWhitespace(character) && character != '=') {
                    defaultValueStartIndex = i;
                }
            }
            ++i;
        }
        String type = typeStartIndex == -1 || typeEndIndex == -1 ? "" : parameterString.substring(typeStartIndex, typeEndIndex);
        if (nameEndIndex == -1) {
            nameEndIndex = parameterString.length();
        }
        if (typeStartIndex == -1) {
            visitor.onError("Missing parameter type: '@param " + parameterString + "'");
        }
        String name = parameterString.substring(nameStartIndex, nameEndIndex);
        String defaultValue = defaultValueStartIndex == -1 ? null : parameterString.substring(defaultValueStartIndex).stripTrailing();
        return new ParamInfo(type, name, defaultValue, varargs, templateLine);
    }
}

