/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler.kotlin;

import gg.jte.ContentType;
import gg.jte.TemplateConfig;
import gg.jte.TemplateException;
import gg.jte.compiler.ClassDefinition;
import gg.jte.compiler.CodeBuilder;
import gg.jte.compiler.CodeGenerator;
import gg.jte.compiler.CodeType;
import gg.jte.compiler.ContentProcessor;
import gg.jte.compiler.ParamInfo;
import gg.jte.compiler.TemplateCompiler;
import gg.jte.compiler.TemplateDependency;
import gg.jte.compiler.TemplateParser;
import gg.jte.compiler.TemplateParserVisitor;
import gg.jte.compiler.TemplateType;
import gg.jte.compiler.kotlin.KotlinParamInfo;
import gg.jte.runtime.ClassInfo;
import gg.jte.runtime.DebugInfo;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class KotlinCodeGenerator
implements CodeGenerator {
    private final TemplateCompiler compiler;
    private final TemplateConfig config;
    private final ConcurrentHashMap<String, List<ParamInfo>> paramOrder;
    private final ClassInfo classInfo;
    private final CodeBuilder kotlinCode = new CodeBuilder(CodeType.Kotlin);
    private final LinkedHashSet<ClassDefinition> classDefinitions;
    private final LinkedHashSet<TemplateDependency> templateDependencies;
    private final List<ParamInfo> parameters = new ArrayList<ParamInfo>();
    private final List<String> imports = new ArrayList<String>();
    private final List<byte[]> binaryTextParts = new ArrayList<byte[]>();
    private final Deque<ForLoopStart> forLoopStack = new ArrayDeque<ForLoopStart>();
    private boolean hasWrittenPackage;
    private boolean hasWrittenClass;
    private CodeBuilder.CodeMarker fieldsMarker;
    private int attributeCounter;
    private int nextForLoopId = 1;

    public KotlinCodeGenerator(TemplateCompiler compiler, TemplateConfig config, ConcurrentHashMap<String, List<ParamInfo>> paramOrder, ClassInfo classInfo, LinkedHashSet<ClassDefinition> classDefinitions, LinkedHashSet<TemplateDependency> templateDependencies) {
        this.compiler = compiler;
        this.config = config;
        this.paramOrder = paramOrder;
        this.classInfo = classInfo;
        this.classDefinitions = classDefinitions;
        this.templateDependencies = templateDependencies;
    }

    public void onImport(String importClass) {
        this.writePackageIfRequired();
        this.imports.add(importClass);
        this.kotlinCode.append("import ").append(importClass).append("\n");
    }

    private void writePackageIfRequired() {
        if (!this.hasWrittenPackage) {
            this.kotlinCode.append("@file:Suppress(\"ktlint\")\n");
            this.kotlinCode.append("package " + this.classInfo.packageName + "\n");
            this.hasWrittenPackage = true;
        }
    }

    public void onParam(String parameter) {
        ParamInfo paramInfo = KotlinParamInfo.parse(parameter, (TemplateParserVisitor)this, this.getCurrentTemplateLine());
        this.writePackageIfRequired();
        if (!this.hasWrittenClass) {
            this.writeClass();
        }
        this.kotlinCode.append(", ");
        if (paramInfo.varargs) {
            this.kotlinCode.append("vararg ");
        }
        this.kotlinCode.append(paramInfo.name).append(':').append(paramInfo.type);
        if (paramInfo.defaultValue != null && !paramInfo.defaultValue.startsWith("@`")) {
            this.kotlinCode.append(" = ").append(paramInfo.defaultValue);
        }
        this.parameters.add(paramInfo);
    }

    private void writeClass() {
        this.kotlinCode.append("@Suppress(\"UNCHECKED_CAST\", \"UNUSED_PARAMETER\")").append('\n');
        this.kotlinCode.append("class ").append(this.classInfo.className).append(" {\n");
        this.kotlinCode.append("companion object {\n");
        this.fieldsMarker = this.kotlinCode.getMarkerOfCurrentPosition();
        this.kotlinCode.append("\t@JvmStatic fun render(");
        this.writeTemplateOutputParam();
        this.kotlinCode.append(", jteHtmlInterceptor:gg.jte.html.HtmlInterceptor?");
        this.hasWrittenClass = true;
    }

    private String getContentClass() {
        if (this.config.contentType == ContentType.Html) {
            return "gg.jte.html.HtmlContent";
        }
        return "gg.jte.Content";
    }

    private void writeTemplateOutputParam() {
        if (this.config.contentType == ContentType.Html) {
            this.kotlinCode.append("jteOutput:gg.jte.html.HtmlTemplateOutput");
        } else {
            this.kotlinCode.append("jteOutput:gg.jte.TemplateOutput");
        }
    }

    public void onParamsComplete() {
        this.writePackageIfRequired();
        if (!this.hasWrittenClass) {
            this.writeClass();
        }
        this.kotlinCode.append(") {\n");
        this.paramOrder.put(this.classInfo.name, this.parameters);
    }

    public void onLineFinished() {
        this.kotlinCode.finishTemplateLine();
    }

    public void onComplete() {
        this.kotlinCode.append("\t}\n");
        this.kotlinCode.append("\t@JvmStatic fun renderMap(");
        this.writeTemplateOutputParam();
        this.kotlinCode.append(", jteHtmlInterceptor:gg.jte.html.HtmlInterceptor?");
        this.kotlinCode.append(", params:Map<String, Any?>) {\n");
        for (ParamInfo parameter : this.parameters) {
            if (parameter.varargs) continue;
            this.writeParameterDeclaration(parameter);
        }
        this.kotlinCode.append("\t\trender(jteOutput, jteHtmlInterceptor");
        for (ParamInfo parameter : this.parameters) {
            if (parameter.varargs) continue;
            this.kotlinCode.append(", ").append(parameter.name);
        }
        this.kotlinCode.append(");\n");
        this.kotlinCode.append("\t}\n");
        this.kotlinCode.append("}\n");
        this.kotlinCode.append("}\n");
        int lineCount = 2;
        if (!this.binaryTextParts.isEmpty()) {
            lineCount += this.binaryTextParts.size() + 1;
        }
        this.kotlinCode.fillLines(this.fieldsMarker, lineCount);
        StringBuilder fields = new StringBuilder();
        this.addNameField(fields, this.classInfo.name);
        this.addLineInfoField(fields);
        this.writeBinaryTextParts(fields);
        this.kotlinCode.insert(this.fieldsMarker, (CharSequence)fields, false);
        this.classInfo.lineInfo = this.kotlinCode.getLineInfo();
    }

    private void writeParameterDeclaration(ParamInfo parameter) {
        boolean nonNullDefaultValue = parameter.defaultValue != null && !parameter.defaultValue.equals("null");
        this.kotlinCode.setCurrentTemplateLine(parameter.templateLine);
        this.kotlinCode.append("\t\tval ").append(parameter.name).append(" = params[\"").append(parameter.name).append("\"] as ");
        if (nonNullDefaultValue) {
            this.kotlinCode.append(this.asNullableType(parameter.type));
            this.kotlinCode.append(" ?: ");
            this.writeCodeWithContentSupport(0, parameter.defaultValue);
        } else {
            this.kotlinCode.append(parameter.type);
        }
        this.kotlinCode.append('\n');
    }

    private String asNullableType(String type) {
        if (type.endsWith("?")) {
            return type;
        }
        return type + "?";
    }

    private void addNameField(StringBuilder fields, String name) {
        fields.append("\t@JvmField val ").append("JTE_NAME").append(" = \"");
        fields.append(name);
        fields.append("\"\n");
    }

    private void addLineInfoField(StringBuilder fields) {
        fields.append("\t@JvmField val ").append("JTE_LINE_INFO").append(" = intArrayOf(");
        for (int i = 0; i < this.kotlinCode.getCurrentCodeLine(); ++i) {
            if (i > 0) {
                fields.append(',');
            }
            fields.append(this.kotlinCode.getLineInfo(i));
        }
        fields.append(")\n");
    }

    private void writeBinaryTextParts(StringBuilder fields) {
        if (this.binaryTextParts.isEmpty()) {
            return;
        }
        this.writeBinaryTextPartsContent(fields);
        this.writeBinaryTextPartsConstants(fields);
    }

    private void writeBinaryTextPartsContent(StringBuilder fields) {
        String contentFileName = new ClassDefinition(this.classInfo.className, "kt").getBinaryTextPartsFileName();
        fields.append("\t@JvmStatic val BINARY_CONTENT = gg.jte.runtime.BinaryContent.load(").append(this.classInfo.className).append("::class.java, \"").append(contentFileName).append("\", ");
        for (int i = 0; i < this.binaryTextParts.size(); ++i) {
            if (i > 0) {
                fields.append(',');
            }
            fields.append(this.binaryTextParts.get(i).length);
        }
        fields.append(");\n");
    }

    private void writeBinaryTextPartsConstants(StringBuilder fields) {
        for (int i = 0; i < this.binaryTextParts.size(); ++i) {
            fields.append("\t@JvmStatic val ").append("TEXT_PART_BINARY_").append(i).append(" = BINARY_CONTENT.get(").append(i).append(")\n");
        }
    }

    public void onError(String message) {
        DebugInfo debugInfo = this.getCurrentDebugInfo();
        throw new TemplateException("Failed to compile " + debugInfo.name + ", error at line " + debugInfo.line + ": " + message);
    }

    public void onError(String message, int templateLine) {
        DebugInfo debugInfo = this.getDebugInfo(templateLine);
        throw new TemplateException("Failed to compile " + debugInfo.name + ", error at line " + debugInfo.line + ": " + message);
    }

    public void onTextPart(int depth, String textPart) {
        if (textPart.isEmpty()) {
            return;
        }
        if (this.config.binaryStaticContent) {
            this.writeTextBinary(depth, textPart);
        } else {
            this.writeTextString(depth, textPart);
        }
    }

    private void writeTextBinary(int depth, String textPart) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.writeBinaryContent(");
        this.kotlinCode.append("TEXT_PART_BINARY_").append(this.binaryTextParts.size());
        this.kotlinCode.append(")\n");
        byte[] bytes = textPart.getBytes(StandardCharsets.UTF_8);
        this.binaryTextParts.add(bytes);
    }

    private void writeTextString(int depth, String textPart) {
        int length = textPart.length();
        if (length < 10922) {
            this.writeText(depth, textPart);
        } else {
            int modifiedUtf8Length = 0;
            int chunkOffset = 0;
            for (int i = 0; i < length; ++i) {
                char c = textPart.charAt(i);
                if (c >= '\u0080' || c == '\u0000') {
                    modifiedUtf8Length += c >= '\u0800' ? 2 : 1;
                }
                if (c >= '\ud800' && c <= '\udbff' || modifiedUtf8Length + (i - chunkOffset + 1) <= 65529) continue;
                this.writeText(depth, textPart.substring(chunkOffset, i + 1));
                modifiedUtf8Length = 0;
                chunkOffset = i + 1;
            }
            if (chunkOffset < length) {
                this.writeText(depth, textPart.substring(chunkOffset));
            }
        }
    }

    private void writeText(int depth, String text) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.writeContent(\"");
        this.kotlinCode.appendEscaped(text);
        this.kotlinCode.append("\")\n");
    }

    public void onCodePart(int depth, String codePart) {
        this.writeCodePart(depth, codePart);
    }

    public void onHtmlTagBodyCodePart(int depth, String codePart, String tagName) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.setContext(\"").append(tagName).append("\", null)\n");
        this.writeCodePart(depth, codePart);
    }

    public void onHtmlTagAttributeCodePart(int depth, String codePart, String tagName, String attributeName) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.setContext(\"").append(tagName).append("\", \"").appendEscaped(attributeName).append("\")\n");
        this.writeCodePart(depth, codePart);
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.setContext(\"").append(tagName).append("\", null)\n");
    }

    public void onUnsafeCodePart(int depth, String codePart) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.writeUnsafeContent(");
        this.kotlinCode.append(codePart);
        this.kotlinCode.append(")\n");
    }

    private void writeCodePart(int depth, String codePart) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteOutput.writeUserContent(");
        this.writeCodeWithContentSupport(depth, codePart);
        this.kotlinCode.append(")\n");
    }

    public void onCodeStatement(int depth, String codePart) {
        this.writeIndentation(depth);
        this.writeCodeWithContentSupport(depth, codePart);
        this.kotlinCode.append("\n");
    }

    public void onConditionStart(int depth, String condition) {
        this.writeIndentation(depth);
        this.kotlinCode.append("if (");
        this.kotlinCode.append(condition);
        this.kotlinCode.append(") {\n");
    }

    public void onConditionElse(int depth, String condition) {
        this.writeIndentation(depth);
        this.kotlinCode.append("} else if (");
        this.kotlinCode.append(condition);
        this.kotlinCode.append(") {\n");
    }

    public void onConditionElse(int depth) {
        this.writeIndentation(depth);
        this.kotlinCode.append("} else {\n");
    }

    public void onConditionEnd(int depth) {
        this.writeIndentation(depth);
        this.kotlinCode.append("}\n");
    }

    public void onForLoopStart(int depth, String codePart) {
        CodeBuilder.CodeMarker beforeLoop = this.kotlinCode.getMarkerOfCurrentPosition();
        this.writeIndentation(depth);
        this.kotlinCode.append("for (").append(codePart).append(") {\n");
        CodeBuilder.CodeMarker inLoop = this.kotlinCode.getMarkerOfCurrentPosition();
        this.forLoopStack.push(new ForLoopStart(beforeLoop, inLoop, depth, this.nextForLoopId++));
    }

    public void onForLoopElse(int depth) {
        ForLoopStart forLoopStart = this.forLoopStack.peek();
        if (forLoopStart != null) {
            String variableName = "__jte_for_loop_entered_" + forLoopStart.id;
            StringBuilder variableDeclaration = new StringBuilder();
            this.writeIndentation(variableDeclaration, forLoopStart.indentation);
            variableDeclaration.append("var ").append(variableName).append(" = false\n");
            this.kotlinCode.insert(forLoopStart.beforeLoop, (CharSequence)variableDeclaration);
            StringBuilder variableAssignment = new StringBuilder();
            this.writeIndentation(variableAssignment, forLoopStart.indentation + 1);
            variableAssignment.append(variableName).append(" = true\n");
            this.kotlinCode.insert(forLoopStart.inLoop, (CharSequence)variableAssignment);
            this.writeIndentation(depth);
            this.kotlinCode.append("}\n");
            this.writeIndentation(depth);
            this.kotlinCode.append("if (!").append(variableName).append(") {\n");
        }
    }

    public void onForLoopEnd(int depth) {
        this.forLoopStack.pop();
        this.writeIndentation(depth);
        this.kotlinCode.append("}\n");
    }

    public void onTemplateCall(int depth, String name, List<String> params) {
        ClassInfo tagInfo = this.compiler.generateTemplateCall(name, "kte", this.classDefinitions, this.templateDependencies, this.getCurrentDebugInfo());
        this.writeIndentation(depth);
        this.kotlinCode.append(tagInfo.fullName).append(".render(jteOutput, jteHtmlInterceptor");
        this.appendParams(depth, tagInfo.name, params);
        this.kotlinCode.append(");\n");
    }

    public void onInterceptHtmlTagOpened(int depth, TemplateParser.HtmlTag htmlTag) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteHtmlInterceptor?.onHtmlTagOpened(\"").append(htmlTag.name).append("\", ");
        this.writeAttributeMap(htmlTag);
        this.kotlinCode.append(", jteOutput)\n");
    }

    public void onInterceptHtmlTagClosed(int depth, TemplateParser.HtmlTag htmlTag) {
        this.writeIndentation(depth);
        this.kotlinCode.append("jteHtmlInterceptor?.onHtmlTagClosed(\"").append(htmlTag.name).append("\", jteOutput)\n");
    }

    public void onHtmlAttributeOutput(int depth, TemplateParser.HtmlTag currentHtmlTag, TemplateParser.HtmlAttribute htmlAttribute) {
        String variableName = this.assignAttributeToVariable(depth, htmlAttribute);
        if (htmlAttribute.bool) {
            this.onConditionStart(depth, variableName);
            this.onTextPart(depth, " " + htmlAttribute.name);
        } else {
            this.onConditionStart(depth, "gg.jte.runtime.TemplateUtils.isAttributeRendered(" + variableName + ")");
            this.onTextPart(depth + 1, " " + htmlAttribute.name + "=" + htmlAttribute.quotes);
            this.onHtmlTagAttributeCodePart(depth + 1, variableName, currentHtmlTag.name, htmlAttribute.name);
            this.onTextPart(depth + 1, "" + htmlAttribute.quotes);
        }
        this.onConditionEnd(depth);
    }

    private String assignAttributeToVariable(int depth, TemplateParser.HtmlAttribute htmlAttribute) {
        String variableName = "__jte_html_attribute_" + this.attributeCounter;
        String variableValue = CodeGenerator.extractSingleOutputTemplateExpression((String)htmlAttribute.value);
        ++this.attributeCounter;
        htmlAttribute.variableName = variableName;
        this.writeIndentation(depth);
        this.kotlinCode.append("val ").append(variableName).append(" = ").append(variableValue).append("\n");
        return variableName;
    }

    private void writeAttributeMap(TemplateParser.HtmlTag htmlTag) {
        CodeGenerator.writeAttributeMap((CodeBuilder)this.kotlinCode, (TemplateParser.HtmlTag)htmlTag);
    }

    private void writeCodeWithContentSupport(int depth, String code) {
        if (code.contains("@`")) {
            new KotlinContentProcessor(depth, code).process();
        } else {
            this.kotlinCode.append(code);
        }
    }

    private DebugInfo getCurrentDebugInfo() {
        return this.getDebugInfo(this.getCurrentTemplateLine());
    }

    private DebugInfo getDebugInfo(int templateLine) {
        return new DebugInfo(this.classInfo.name, templateLine + 1);
    }

    public int getCurrentTemplateLine() {
        return this.kotlinCode.getCurrentTemplateLine();
    }

    public List<ParamInfo> getParamInfo() {
        return this.parameters;
    }

    public List<String> getImports() {
        return this.imports;
    }

    private void appendParams(int depth, String name, List<String> params) {
        List<ParamInfo> paramInfos = this.paramOrder.get(name);
        if (paramInfos == null) {
            throw new IllegalStateException("No parameter information for " + name);
        }
        int index = 0;
        ParamCallInfo[] paramCallInfos = new ParamCallInfo[Math.max(params.size(), paramInfos.size())];
        for (String param : params) {
            ParamCallInfo paramCallInfo = new ParamCallInfo(param);
            int parameterIndex = this.getParameterIndex(name, paramInfos, paramCallInfo);
            if (parameterIndex == -1) {
                parameterIndex = index;
            }
            paramCallInfos[parameterIndex] = paramCallInfo;
            ++index;
        }
        for (int i = 0; i < paramCallInfos.length; ++i) {
            ParamCallInfo paramCallInfo = paramCallInfos[i];
            if (paramCallInfo != null) {
                this.appendParam(depth, paramCallInfo.data);
                continue;
            }
            ParamInfo paramInfo = paramInfos.get(i);
            if (paramInfo.defaultValue == null) continue;
            this.appendParam(depth, paramInfo.defaultValue);
        }
    }

    private void appendParam(int depth, String param) {
        this.kotlinCode.append(", ");
        this.writeCodeWithContentSupport(depth, param);
    }

    private int getParameterIndex(String name, List<ParamInfo> paramInfos, ParamCallInfo paramCallInfo) {
        if (paramCallInfo.name == null) {
            return -1;
        }
        for (int i = 0; i < paramInfos.size(); ++i) {
            if (!paramInfos.get((int)i).name.equals(paramCallInfo.name)) continue;
            return i;
        }
        throw new TemplateException("Failed to compile template, error at " + this.classInfo.name + ":" + this.getCurrentTemplateLine() + ". No parameter with name " + paramCallInfo.name + " is defined in " + name);
    }

    private void writeIndentation(int depth) {
        for (int i = 0; i < depth + 2; ++i) {
            this.kotlinCode.append('\t');
        }
    }

    private void writeIndentation(StringBuilder code, int depth) {
        for (int i = 0; i < depth + 2; ++i) {
            code.append('\t');
        }
    }

    public String getCode() {
        return this.kotlinCode.getCode();
    }

    public List<byte[]> getBinaryTextParts() {
        return this.binaryTextParts;
    }

    private record ForLoopStart(CodeBuilder.CodeMarker beforeLoop, CodeBuilder.CodeMarker inLoop, int indentation, int id) {
    }

    class KotlinContentProcessor
    extends ContentProcessor {
        KotlinContentProcessor(int depth, String param) {
            super(depth, param);
        }

        protected void onContentBlock(int depth, String code, int lastWrittenIndex, int startIndex, int endIndex) {
            KotlinCodeGenerator.this.kotlinCode.append(code, lastWrittenIndex + 1, startIndex - 2);
            KotlinCodeGenerator.this.kotlinCode.append("object : ").append(KotlinCodeGenerator.this.getContentClass()).append(" {\n");
            KotlinCodeGenerator.this.writeIndentation(depth + 1);
            KotlinCodeGenerator.this.kotlinCode.append("override fun writeTo(");
            KotlinCodeGenerator.this.writeTemplateOutputParam();
            KotlinCodeGenerator.this.kotlinCode.append(") {\n");
            TemplateParser parser = new TemplateParser(code, TemplateType.Content, (TemplateParserVisitor)KotlinCodeGenerator.this, KotlinCodeGenerator.this.config);
            parser.setStartIndex(startIndex);
            parser.setEndIndex(endIndex);
            parser.setParamsComplete(true);
            parser.parse(depth + 2);
            KotlinCodeGenerator.this.writeIndentation(depth + 1);
            KotlinCodeGenerator.this.kotlinCode.append("}\n");
            KotlinCodeGenerator.this.writeIndentation(depth);
            KotlinCodeGenerator.this.kotlinCode.append("}");
        }

        protected void onRemainingCode(String code, int startIndex, int endIndex) {
            KotlinCodeGenerator.this.kotlinCode.append(code, startIndex, endIndex);
        }
    }

    private static final class ParamCallInfo {
        final String name;
        final String data;

        public ParamCallInfo(String param) {
            param = param.trim();
            int nameEndIndex = -1;
            int dataStartIndex = -1;
            for (int i = 0; i < param.length(); ++i) {
                char character = param.charAt(i);
                if (nameEndIndex == -1) {
                    if (character == '\"' || character == '\'') break;
                    if (character != '=') continue;
                    nameEndIndex = i;
                    continue;
                }
                if (dataStartIndex != -1 || Character.isWhitespace(character)) continue;
                dataStartIndex = i;
            }
            if (nameEndIndex != -1 && dataStartIndex != -1) {
                this.name = param.substring(0, nameEndIndex).trim();
                this.data = param.substring(dataStartIndex).trim();
            } else {
                this.name = null;
                this.data = param;
            }
        }
    }
}

