/*
 * Decompiled with CFR 0.152.
 */
package gg.jte.compiler.kotlin;

import gg.jte.TemplateConfig;
import gg.jte.TemplateException;
import gg.jte.compiler.ClassCompiler;
import gg.jte.compiler.ClassUtils;
import gg.jte.runtime.ClassInfo;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.config.Services;

public class KotlinClassCompiler
implements ClassCompiler {
    public void compile(String[] files, List<String> classPath, TemplateConfig config, Path classDirectory, Map<String, ClassInfo> templateByClassName) {
        SimpleKotlinCompilerMessageCollector messageCollector;
        K2JVMCompiler compiler;
        ExitCode exitCode;
        K2JVMCompilerArguments compilerArguments = new K2JVMCompilerArguments();
        compilerArguments.setJavaParameters(true);
        compilerArguments.setNoStdlib(true);
        compilerArguments.setDestination(classDirectory.toFile().getAbsolutePath());
        compilerArguments.setFreeArgs(Arrays.asList(files));
        compilerArguments.setClasspath(ClassUtils.join(classPath));
        if (config.kotlinCompileArgs != null) {
            this.applyCompileArgs(compilerArguments, config.kotlinCompileArgs);
        }
        if ((exitCode = (compiler = new K2JVMCompiler()).exec((MessageCollector)(messageCollector = new SimpleKotlinCompilerMessageCollector(templateByClassName, config.packageName)), new Services.Builder().build(), (CommonToolArguments)compilerArguments)) != ExitCode.OK && exitCode != ExitCode.COMPILATION_ERROR) {
            throw new TemplateException(messageCollector.getErrorMessage());
        }
        if (messageCollector.hasErrors()) {
            throw new TemplateException(messageCollector.getErrorMessage());
        }
    }

    private void applyCompileArgs(K2JVMCompilerArguments compilerArguments, String[] kotlinCompileArgs) {
        for (int i = 0; i < kotlinCompileArgs.length; ++i) {
            if (!"-jvm-target".equals(kotlinCompileArgs[i])) continue;
            compilerArguments.setJvmTarget(kotlinCompileArgs[++i]);
        }
    }

    private static class SimpleKotlinCompilerMessageCollector
    implements MessageCollector {
        private final Map<String, ClassInfo> templateByClassName;
        private final List<String> errors = new ArrayList<String>();
        private final String packageName;
        private String className;
        private int line;

        private SimpleKotlinCompilerMessageCollector(Map<String, ClassInfo> templateByClassName, String packageName) {
            this.templateByClassName = templateByClassName;
            this.packageName = packageName;
        }

        public void clear() {
        }

        public boolean hasErrors() {
            return !this.errors.isEmpty();
        }

        public void report(CompilerMessageSeverity severity, String s, CompilerMessageSourceLocation location) {
            if (severity.isError()) {
                if (location != null && location.getLineContent() != null) {
                    if (this.className == null) {
                        this.className = this.extractClassName(location);
                        this.line = location.getLine();
                    }
                    this.errors.add(String.format("%s%n%s:%d:%d%nReason: %s", location.getLineContent(), location.getPath(), location.getLine(), location.getColumn(), s));
                } else {
                    this.errors.add(s);
                }
            }
        }

        private String extractClassName(CompilerMessageSourceLocation location) {
            String path = location.getPath();
            path = path.replace('/', '.').replace('\\', '.');
            int packageIndex = path.indexOf(this.packageName);
            path = path.substring(packageIndex);
            path = path.substring(0, path.length() - 3);
            return path;
        }

        public String getErrorMessage() {
            String allErrors = String.join((CharSequence)"\n", this.errors);
            if (this.className != null) {
                ClassInfo templateInfo = this.templateByClassName.get(this.className);
                int templateLine = templateInfo.lineInfo[this.line - 1] + 1;
                return "Failed to compile template, error at " + templateInfo.name + ":" + templateLine + "\n" + allErrors;
            }
            return "Failed to compile template, error at\n" + this.errors;
        }
    }
}

