/*
 * Decompiled with CFR 0.152.
 */
package gg.jte;

import gg.jte.CodeResolver;
import gg.jte.ContentType;
import gg.jte.TemplateException;
import gg.jte.TemplateOutput;
import gg.jte.html.HtmlInterceptor;
import gg.jte.html.HtmlPolicy;
import gg.jte.html.HtmlTemplateOutput;
import gg.jte.html.OwaspHtmlTemplateOutput;
import gg.jte.internal.DebugInfo;
import gg.jte.internal.RuntimeTemplateLoader;
import gg.jte.internal.Template;
import gg.jte.internal.TemplateLoader;
import gg.jte.internal.TemplateMode;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class TemplateEngine {
    private final TemplateLoader templateLoader;
    private final TemplateMode templateMode;
    private final ConcurrentMap<String, Template> templateCache;
    private final ContentType contentType;
    private HtmlInterceptor htmlInterceptor;

    public static TemplateEngine create(CodeResolver codeResolver, ContentType contentType) {
        return TemplateEngine.create(codeResolver, Path.of("jte-classes", new String[0]), contentType);
    }

    public static TemplateEngine create(CodeResolver codeResolver, Path classDirectory, ContentType contentType) {
        return new TemplateEngine(codeResolver, classDirectory, contentType, TemplateMode.OnDemand);
    }

    public static TemplateEngine createPrecompiled(Path classDirectory, ContentType contentType) {
        return new TemplateEngine(null, classDirectory, contentType, TemplateMode.Precompiled);
    }

    public static TemplateEngine createPrecompiled(ContentType contentType) {
        return TemplateEngine.createPrecompiled(null, contentType);
    }

    private TemplateEngine(CodeResolver codeResolver, Path classDirectory, ContentType contentType, TemplateMode templateMode) {
        if (contentType == null) {
            throw new NullPointerException("Content type must be specified.");
        }
        this.templateLoader = TemplateEngine.createTemplateLoader(codeResolver, classDirectory, contentType, templateMode);
        this.templateMode = templateMode;
        this.templateCache = new ConcurrentHashMap<String, Template>();
        this.contentType = contentType;
        if (templateMode == TemplateMode.OnDemand) {
            this.cleanAll();
        }
    }

    private static TemplateLoader createTemplateLoader(CodeResolver codeResolver, Path classDirectory, ContentType contentType, TemplateMode templateMode) {
        if (templateMode == TemplateMode.Precompiled) {
            return new RuntimeTemplateLoader(classDirectory);
        }
        try {
            Class<?> compilerClass = Class.forName("gg.jte.internal.TemplateCompiler");
            return (TemplateLoader)compilerClass.getConstructor(CodeResolver.class, Path.class, ContentType.class).newInstance(new Object[]{codeResolver, classDirectory, contentType});
        }
        catch (Exception e) {
            throw new TemplateException("TemplateCompiler could not be located. Maybe jte isn't on your classpath?", e);
        }
    }

    public void render(String name, Object param, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            template.render(this.checkOutput(output), this.htmlInterceptor, param);
        }
        catch (Throwable e) {
            this.handleRenderException(name, template, e);
        }
    }

    public void render(String name, Map<String, Object> params, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            template.renderMap(this.checkOutput(output), this.htmlInterceptor, params);
        }
        catch (Throwable e) {
            this.handleRenderException(name, template, e);
        }
    }

    public void renderTag(String name, Map<String, Object> params, TemplateOutput output) throws TemplateException {
        Template template = this.resolveTemplate(name);
        try {
            template.renderMap(this.checkOutput(output), this.htmlInterceptor, params);
        }
        catch (Throwable e) {
            this.handleRenderException(name, template, e);
        }
    }

    public void renderLayout(String name, Map<String, Object> params, TemplateOutput output) throws TemplateException {
        this.renderTag(name, params, output);
    }

    private TemplateOutput checkOutput(TemplateOutput templateOutput) {
        if (this.contentType == ContentType.Html && !(templateOutput instanceof HtmlTemplateOutput)) {
            return new OwaspHtmlTemplateOutput(templateOutput);
        }
        return templateOutput;
    }

    private void handleRenderException(String name, Template template, Throwable e) {
        DebugInfo debugInfo = this.templateLoader.resolveDebugInfo(template.getClassLoader(), e.getStackTrace());
        String message = "Failed to render " + name;
        if (debugInfo != null) {
            message = message + ", error at " + debugInfo.name + ":" + debugInfo.line;
        }
        throw new TemplateException(message, e);
    }

    public List<String> getTemplatesUsing(String name) {
        if (name.startsWith("tag/") || name.startsWith("layout/")) {
            return this.templateLoader.getTemplatesUsing(name);
        }
        return Collections.singletonList(name);
    }

    public void prepareForRendering(String name) {
        this.resolveTemplate(name);
    }

    public void cleanAll() {
        this.templateLoader.cleanAll();
    }

    public int precompileAll() {
        return this.precompileAll(null);
    }

    public int precompileAll(List<String> compilePath) {
        return this.templateLoader.precompileAll(compilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template resolveTemplate(String name) {
        if (this.templateMode == TemplateMode.OnDemand && this.templateLoader.hasChanged(name)) {
            ConcurrentMap<String, Template> concurrentMap = this.templateCache;
            synchronized (concurrentMap) {
                if (this.templateLoader.hasChanged(name)) {
                    Template template = this.templateLoader.load(name);
                    this.templateCache.put(name, template);
                    return template;
                }
            }
        }
        return this.templateCache.computeIfAbsent(name, this.templateLoader::load);
    }

    public void setNullSafeTemplateCode(boolean value) {
        this.templateLoader.setNullSafeTemplateCode(value);
    }

    public void setHtmlPolicy(HtmlPolicy htmlPolicy) {
        if (htmlPolicy == null) {
            throw new NullPointerException("htmlPolicy must not be null");
        }
        this.templateLoader.setHtmlPolicy(htmlPolicy);
    }

    public void setHtmlTags(String ... htmlTags) {
        this.templateLoader.setHtmlTags(htmlTags);
    }

    public void setHtmlAttributes(String ... htmlAttributes) {
        this.templateLoader.setHtmlAttributes(htmlAttributes);
    }

    public void setHtmlInterceptor(HtmlInterceptor htmlInterceptor) {
        this.htmlInterceptor = htmlInterceptor;
    }
}

